library(nanonext)
nanotest <- function(x) invisible(x || stop())
nanotestw <- function(x) invisible(suppressWarnings(x) || stop())

n <- nano("pair", listen = "inproc://nanonext", autostart = FALSE)
n1 <- nano("pair", dial = "inproc://nanonext", autostart = FALSE)
nanotest(inherits(n, "nanoObject"))
nanotest(inherits(n$socket, "nanoSocket"))
nanotest(inherits(n$socket, "nano"))
nanotest(is.integer(attr(n$socket, "id")))
nanotest(n$socket$state == "opened")
nanotest(n$socket$protocol == "pair")
nanotestw(n$send("not ready") > 0L)
nanotestw(n$recv() > 0L)
nanotest(n$socket_setopt("size", "recv-size-max", 8192) == 0)
nanotest(n$socket_setopt("int", "recv-buffer", 8) == 0)
nanotest(n$socket_setopt("string", "socket-name", "nano") == 0)

nanotest(inherits(n$listener[[1]], "nanoListener"))
nanotest(n$listener[[1]]$url == "inproc://nanonext")
nanotest(n$listener[[1]]$state == "not started")
nanotest(n$listener_setopt("size", "recv-size-max", 1024) == 0)
nanotest(n$listener_start() == 0L)
nanotest(n$listener[[1]]$state == "started")

nanotest(inherits(n1$dialer[[1]], "nanoDialer"))
nanotest(n1$dialer[[1]]$url == "inproc://nanonext")
nanotest(n1$dialer[[1]]$state == "not started")
nanotest(n1$dialer_setopt("ms", "reconnect-time-min", 1000) == 0)
nanotest(n1$dialer_setopt("size", "recv-size-max", 8192) == 0)
nanotest(n1$dialer_start() == 0L)
nanotest(n1$dialer[[1]]$state == "started")

invisible(n$send(data.frame(), block = FALSE, echo = FALSE))
invisible(n1$recv(block = FALSE))
n1$send("test", mode = "raw", block = 500, echo = FALSE)
invisible(n$recv("character", block = 500))
saio <- n$send_aio(data.frame(), timeout = 500)
nanotest(!is.null(saio[["aio"]]))
nanotest(!is.null(saio$result))
raio <- n1$recv_aio(timeout = 500)
nanotest(!is.null(raio[["aio"]]))
nanotest(!is.null(raio$data))
nanotest(!is.null(raio$raw))
saio <- n$send_aio(c(1.1, 2.2), mode = "raw", timeout = 500)
nanotest(is.logical(unresolved(saio)))
msg <- n1$recv_aio(timeout = 500)
nanotest(is.null(stop_aio(msg)))
nanotest(is.null(stop_aio(n)))
nanotest(identical(call_aio(msg), msg))
nanotest(identical(call_aio(n), n))

xc <- n$dial(url = "inproc://two", autostart = TRUE)
nanotest(is.integer(xc))
nanotest(inherits(n$dialer[[1L]], "nanoDialer"))
xc <- n$listen(url = "inproc://three")
nanotest(is.integer(xc))
nanotest(inherits(n$listener[[2L]], "nanoListener"))

nanotest(close(n$listener[[1]]) == 0L)
nanotestw(close(n$listener[[1]]) > 0L)
nanotest(close(n1$dialer[[1]]) == 0L)
nanotestw(close(n1$dialer[[1]]) > 0L)
nanotest(n$close() == 0L)
nanotest(n1$close() == 0L)
nanotestw(n1$close() > 0L)
nanotest(n$socket[["state"]] == "closed")
nanotest(n1$socket[state] == "closed")

n <- nano("req", listen = "inproc://testing")
n1 <- nano("rep", dial = "inproc://testing")
nanotest(n$socket_setopt("ms", "req:resend-time", 1000) == 0)
ctx <- context(n$socket)
ctx1 <- context(n1$socket)
nanotest(inherits(ctx, "nanoContext"))
nanotest(inherits(ctx, "nano"))
nanotest(is.integer(ctx$id))
nanotest(ctx$state == "opened")
nanotest(ctx$protocol == "req")
nanotest(setopt(ctx, "ms", "send-timeout", 1000) == 0L)
send(ctx, data.frame(), block = 500, echo = FALSE)
invisible(recv(ctx1, block = 500))
send(ctx, "context test", mode ="raw", block = 500, echo = FALSE)
invisible(recv(ctx1, mode = "character", block = 100))
nanotest(close(ctx) == 0L)
nanotestw(close(ctx) > 0L)
nanotest(ctx$state == "closed")
ctx2 <- context(n1)
nanotest(close(ctx2) == 0L)

pub <- nano("pub", listen = "inproc://ps")
sub <- nano("sub", dial = "inproc://ps")
nanotest(subscribe(sub$socket, "test") == 0L)
nanotest(subscribe(sub$socket, NULL) == 0L)
nanotest(unsubscribe(sub$socket, NULL) == 0L)
nanotest(unsubscribe(sub$socket, "test") == 0L)
nanotest(sub$close() == 0L)
nanotest(pub$close() == 0L)

sock <- socket(protocol = "surveyor", listen = "inproc://sock1", dial = "inproc://sock2")
sock2 <- socket(protocol = "respondent", listen = "inproc://sock2", dial = "inproc://sock1")
nanotest(!is.null(sock$dialer) && !is.null(sock$listener))
nanotest(close(sock) == 0L)
nanotest(close(sock2) == 0L)

nanotestw(is.integer(ncurl("http://127.0.0.1:5555", method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test")))
nanotestw(is.integer(ncurl("http://127.0.0.1:5555", method = "PUT", headers = list(Authorization = "Bearer token"), data = "test")))
nanotestw(is.integer(stream(dial = "tcp://127.0.0.1:5555")))

nanotest(is.character(ver <- nng_version()) && length(ver) == 2L)
nanotest(is.character(nng_error(0L)))
nanotest(is_nul_byte(as.raw(0L)) && !is_nul_byte(NULL))
nanotest(!is_error_value(1L))

nanotest(inherits(bus <- socket(protocol = "bus"), "nanoSocket"))
nanotest(inherits(push <- socket(protocol = "push"), "nanoSocket"))
nanotest(inherits(pull <- socket(protocol = "pull"), "nanoSocket"))
nanotest(close(bus) == 0L)
nanotest(close(push) == 0L)
nanotest(close(pull) == 0L)

