% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{close}
\alias{close}
\alias{close.nanoSocket}
\alias{close.nanoContext}
\alias{close.nanoDialer}
\alias{close.nanoListener}
\title{Close Connection}
\usage{
\method{close}{nanoSocket}(con, ...)

\method{close}{nanoContext}(con, ...)

\method{close}{nanoDialer}(con, ...)

\method{close}{nanoListener}(con, ...)
}
\arguments{
\item{con}{a Socket, Context, Dialer or Listener.}

\item{...}{not used.}
}
\value{
Zero (invisibly) on success.
}
\description{
Close Connection on a Socket, Context, Dialer or Listener.
}
\details{
Closing an object explicitly frees its resources. An object can also
    be removed directly in which case its resources are freed when the object
    is garbage collected.

    Dialers and Listeners are implicitly closed when the socket they are
    associated with is closed.

    Closing a socket associated with a context also closes the context.

    When closing a socket or a context: messages that have been submitted for
    sending may be flushed or delivered, depending upon the transport. Closing
    the socket while data is in transmission will likely lead to loss of that
    data. There is no automatic linger or flush to ensure that the socket
    send buffers have completely transmitted.
}
