\name{nFactors-package}
\alias{nFactors-package}
\alias{nFactors}
\docType{package}
\title{ Parallel Analysis and Non Graphical Solutions to the Cattell Scree Test}


\description{
 Indices, heuristics and strategies to help determine the number of factors/components to retain:
  \enumerate{
  \item{- }{ Acceleration factor (\emph{noc} with or without Parallel Analysis)  }
  \item{- }{ Optimal Coordinates (\emph{noc} with or without Parallel Analysis) }
  \item{- }{ Parallel analysis (components, factors and bootstrap)  }
  \item{- }{ \eqn{\lambda >= \bar{\lambda}} (Kaiser, CFA and related rule) }
  \item{- }{ Cattell-Nelson-Gorsuch (\emph{CNG})  }
  \item{- }{ Zoski and Jurs Multiple regression (\eqn{\beta}, \emph{t} and \emph{p})  }
  \item{- }{ Zoski and Jurs standard error of the regression coefficient (sescree, \eqn{S_{Y \bullet X}})  }
  \item{- }{ Nelson \eqn{R^2}  }
  \item{- }{ Bartlett \eqn{\chi^2}  }
  \item{- }{ Anderson \eqn{\chi^2}  }
  \item{- }{ Lawley \eqn{\chi^2} and  }
  \item{- }{ Bentler-Yuan \eqn{\chi^2}.  }
  }
 }


\details{
 \tabular{ll}{
  Package: \tab nFactors \cr
  Type:    \tab Package \cr
  Version: \tab 2.3.2 \cr
  Date:    \tab 2010-04-10 \cr
  Depends: \tab R (>= 2.9.2), MASS, psych, boot \cr
  License: \tab GPL \cr
  }
 }


\author{
    Gilles Raiche \cr
    Centre sur les Applications des Modeles de Reponses aux Items (CAMRI) \cr
    Universite du Quebec a Montreal\cr
    \email{raiche.gilles@uqam.ca}, \url{http://www.er.uqam.ca/nobel/r17165/} \cr \cr
    David Magis \cr
    Departement de mathematiques \cr
    Universite de Liege \cr
    \email{David.Magis@ulg.ac.be}
 }

 \references{
  Raiche, G., Riopel, M. and Blais, J.-G. (2006). \emph{Non graphical solutions
   for the Cattell's scree test}. Paper presented at the International Annual
   meeting of the Psychometric Society, Montreal.
  [\url{http://www.er.uqam.ca/nobel/r17165/RECHERCHE/COMMUNICATIONS/}]
 }


\seealso{
 Other packages are also very useful for principal component and factor analysis. The \emph{R} psychometric view is instructive at this point.
 See \url{http://cran.stat.sfu.ca/web/views/Psychometrics.html} for further details.
 }


\keyword{ package }



