% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_reduce_umap_params.R
\name{validate_reduce_umap_params}
\alias{validate_reduce_umap_params}
\title{Internal function to validate parameters passed to \code{run_reduce_umap}}
\usage{
validate_reduce_umap_params(
  mx_data,
  table,
  marker_list,
  downsample_pct,
  metadata_cols
)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object used to compute UMAP dimensions}

\item{table}{dataset in \code{mx_data} used to compute metrics. Options include: c("raw","normalized","both"), e.g. a y-axis parameter.}

\item{marker_list}{list of markers in the \code{mx_dataset} object to use for UMAP algorithm}

\item{downsample_pct}{double, optional percentage (0, 1] of sample rows to include when running UMAP algorithm. (default=1)}

\item{metadata_cols}{other identifiers of the input \code{data} (default=NULL). This must be a vector of column name(s) in the \code{mx_dataset} object}
}
\value{
\code{mx_datast} object
}
\description{
Internal function to validate parameters passed to \code{run_reduce_umap}
}
