% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sofr.R
\name{run_sofr}
\alias{run_sofr}
\title{Run Scalar on Function Regression}
\usage{
run_sofr(
  mxFDAobject,
  model_name,
  formula,
  family = "gaussian",
  metric = "uni k",
  r = "r",
  value = "fundiff",
  smooth = FALSE,
  filter_cols = NULL,
  ...,
  knots = NULL
)
}
\arguments{
\item{mxFDAobject}{Dataframe of spatial summary functions from multiplex imaging data, in long format. Can be estimated using the function \code{extract_summary_functions} or provided separately.}

\item{model_name}{character string to give the fit model}

\item{formula}{Formula to be fed to mgcv in the form of outcome ~ x1 + x2. Does not contain functional predictor. Character valued.}

\item{family}{Exponential family distribution to be passed to \code{mgcv::gam}. Defaults to "gaussian". Select "binomial" for binary outcome.}

\item{metric}{Name of calculated spatial metric to use}

\item{r}{Character string, the name of the variable that identifies the function domain (usually a radius for spatial summary functions). Default is "r".}

\item{value}{Character string, the name of the variable that identifies the spatial summary function values. Default is "fundiff".}

\item{smooth}{Option to smooth data using FPCA. Defaults to FALSE.}

\item{filter_cols}{a named vector of factors to filter summary functions to in \code{c(Derived_Column = "Level_to_Filter")} format}

\item{...}{Optional other arguments to be passed to \code{fpca.face}}

\item{knots}{Number of knots for defining spline basis.}
}
\value{
A \code{list} which is a linear or additive functional Cox model fit. See \code{mgcv::gam} for more details.
}
\description{
Fit a scalar-on-function regression model. Uses refund::pfr under the hood for computations, and stores results in the mxfda object.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
#load ovarian mxFDA object
data('ovarian_FDA')

# run scalar on function regression model with a continuous outcome (age)
ovarian_FDA = run_sofr(ovarian_FDA,
                       model_name = "fit_sofr",
                       formula = age~stage,
                       metric = "uni g", r = "r", value = "fundiff")

# run scalar on function regression model with a binary outcome (stage)
# also known as functional logistic regression
ovarian_FDA = run_sofr(ovarian_FDA,
                       model_name = "fit_sofr",
                       formula = stage~age,
                       family = "binomial",
                       metric = "uni g", r = "r", value = "fundiff")

}
\author{
Julia Wrobel \email{julia.wrobel@emory.edu}

Alex Soupir \email{alex.soupir@moffitt.org}
}
