% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_bivariate.R
\name{bivariate}
\alias{bivariate}
\title{bivariate}
\usage{
bivariate(
  mximg,
  markvar,
  mark1,
  mark2,
  r_vec,
  func = c(Kcross, Lcross, Gcross, entropy),
  edge_correction,
  breaks = NULL
)
}
\arguments{
\item{mximg}{Dataframe of cell-level multiplex imaging data for a single image.
Should have variables \code{x} and \code{y} to denote x and y spatial locations of each cell.}

\item{markvar}{The name of the variable that denotes cell type(s) of interest. Character.}

\item{mark1}{Character string that denotes first cell type of interest.}

\item{mark2}{Character string that denotes second cell type of interest.}

\item{r_vec}{Numeric vector of radii over which to evaluate spatial summary functions. Must begin at 0.}

\item{func}{Spatial summary function to calculate. Options are c(Kcross, Lcross, Gcross) which denote Ripley's K, Besag's L, and nearest neighbor G function, respectively, or entropy from Vu et al, 2023.}

\item{edge_correction}{Character string that denotes the edge correction method for spatial summary function. For Kcross and Lcross choose one of c("border", "isotropic", "Ripley", "translate", "none"). For Gcross choose one of c("rs", "km", "han")}

\item{breaks}{an integer for the number of breaks used for entropy}
}
\value{
A \code{data.frame} containing:
\item{r}{the radius of values over which the spatial summary function is evaluated}
\item{sumfun}{the values of the spatial summary function}
\item{csr}{the values of the spatial summary function under complete spatial randomness}
\item{fundiff}{sumfun - csr, positive values indicate clustering and negative values repulsion}
}
\description{
Internal function called by \code{extract_summary_functions} to calculate a bivariate spatial summary function for a single image.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\references{
Xiao, L., Ruppert, D., Zipunnikov, V., and Crainiceanu, C. (2016).
Fast covariance estimation for high-dimensional functional data.
\emph{Statistics and Computing}, 26, 409-421.
DOI: 10.1007/s11222-014-9485-x.

Vu, T., Seal, S., Ghosh, T., Ahmadian, M., Wrobel, J., & Ghosh, D. (2023).
FunSpace: A functional and spatial analytic approach to cell imaging data using entropy measures.
\emph{PLOS Computational Biology}, 19(9), e1011490.
}
\author{
Julia Wrobel \email{julia.wrobel@emory.edu}
}
