% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mvtb_summary.R
\name{summary.mvtb}
\alias{summary.mvtb}
\title{Computes a summary of the multivariate tree boosting model}
\usage{
\method{summary}{mvtb}(object, print = TRUE, n.trees = NULL,
  relative = "col", covex = TRUE, ...)
}
\arguments{
\item{object}{mvtb output object}

\item{print}{result (default is TRUE)}

\item{n.trees}{number of trees used to compute relative influence. Defaults to the minimum number of trees by CV, test, or training error}

\item{relative}{relative If 'col', each column sums to 100. If 'tot', the whole matrix sums to 100 (a percent). If 'n', the raw reductions in SSE are returned.}

\item{covex}{Whether to print covariance explained}

\item{...}{unused}
}
\value{
Returns the best number of trees, the univariate relative influence of each predictor for each outcome, and covariance explained in pairs of outcomes by each predictor
}
\description{
Computes a summary of the multivariate tree boosting model
}
\seealso{
\code{mvtb.ri}, \code{gbm.ri}, \code{mvtb.cluster}
}

