% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mvss.R
\name{fit_mvss}
\alias{fit_mvss}
\title{Fit a Multivariate Subgaussian Distribution}
\usage{
fit_mvss(x)
}
\arguments{
\item{x}{a matrix for which the parameters for a \code{d}-dimensional multivariate
subgaussian distribution will be estimated.  The number of columns will be \code{d}.}
}
\value{
A list with parameters from the column-wise univariate fits and
the multivariate alpha and shape matrix estimates (the \code{univ_deltas} are the \code{mult_deltas}):
\itemize{
\item \code{univ_alphas} - the alphas from the column-wise univariate fits
\item \code{univ_betas}  - the betas  from the column-wise univariate fits
\item \code{univ_gammas} - the gammas from the column-wise univariate fits
\item \code{univ_deltas} - the deltas from the column-wise univariate fits
\item \code{mult_alpha}  - the mean(univ_alphas); equivalently the multivariate alpha estimate
\item \code{mult_Q_raw}  - the multivariate shape matrix estimate (before applying \code{nearPD()})
\item \code{mult_Q_posdef}   - the nearest positive definite multivariate shape matrix estimate, \code{nearPD(mult_Q_raw)}
}
}
\description{
Estimates the parameters (namely, alpha, shape matrix Q, and location vector)
of the multivariate subgaussian
distribution for an input matrix X.
}
\details{
Using the protocols outlined in Nolan (2013), this function uses \code{libstable4u}'s univariate
fit functions for each component.
}
\examples{
\donttest{
## create a 4x4 shape matrix symMat
S <- matrix(rnorm(4*4, mean=2, sd=4),4); 
symMat <- as.matrix(Matrix::nearPD(0.5 * (S + t(S)))$mat)
symMat
## generate 10,000 r.v.'s from 4-dimensional mvss
X <- mvpd::rmvss(1e4, alpha=1.5, Q=symMat, delta=c(1,2,3,4))
## use fit_mvss to recover the parameters, compare to symMat
fmv <- mvpd::fit_mvss(X)
fmv
symMat
## then use the fitted parameters to calculate a probability:
mvpd::pmvss(lower=rep(0,4),
            upper=rep(5,4),
            alpha=fmv$mult_alpha,
            Q=fmv$mult_Q_posdef,
            delta=fmv$univ_deltas,
            maxpts.pmvnorm = 25000*10)
}

}
\references{
Nolan JP (2013), \emph{Multivariate elliptically contoured stable distributions:
theory and estimation}. Comput Stat (2013) 28:2067–2089
DOI 10.1007/s00180-013-0396-7
}
\seealso{
\code{Rfast::mvnorm.mle}, \code{alphastable::mfitstab.elliptical}
}
\keyword{distribution}
