% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpower.R
\name{mpower}
\alias{mpower}
\alias{\%^\%}
\title{General Matrix Power}
\usage{
mpower(A, n)

A \%^\% n
}
\arguments{
\item{A}{A square matrix. Must also be symmetric for non-integer powers.}

\item{n}{matrix power}
}
\value{
Returns the matrix \eqn{A^n}
}
\description{
Calculates the \code{n}-th power of a square matrix, where \code{n} can be a
positive or negative integer or a fractional power.
}
\details{
If \code{n<0}, the method is applied to \eqn{A^{-1}}. 
When \code{n} is an
integer, the function uses the Russian peasant method, or repeated squaring
for efficiency.  
Otherwise, it uses the spectral decomposition of \code{A},
\eqn{\mathbf{A}^n = \mathbf{V} \mathbf{D}^n \mathbf{V}^{T}}
requiring a symmetric matrix.
}
\examples{

M <- matrix(sample(1:9), 3,3)
mpower(M,2)
mpower(M,4)

# make a symmetric matrix
MM <- crossprod(M)
mpower(MM, -1)
Mhalf <- mpower(MM, 1/2)
all.equal(MM, Mhalf \%*\% Mhalf)


}
\references{
\url{https://en.wikipedia.org/wiki/Exponentiation_by_squaring}
}
\seealso{
Packages \pkg{corpcor} and \pkg{expm} define similar functions.
}
\author{
Michael Friendly
}
\keyword{array}
