% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gratia_methods.R
\name{gratia_mvgam_enhancements}
\alias{gratia_mvgam_enhancements}
\alias{drawDotmvgam}
\alias{draw.mvgam}
\alias{eval_smoothDothilbertDotsmooth}
\alias{eval_smooth.hilbert.smooth}
\alias{eval_smoothDotmodDotsmooth}
\alias{eval_smooth.mod.smooth}
\alias{eval_smoothDotmoiDotsmooth}
\alias{eval_smooth.moi.smooth}
\title{Enhance mvgam post-processing using gratia functionality}
\usage{
drawDotmvgam(
  object,
  trend_effects = FALSE,
  data = NULL,
  select = NULL,
  parametric = FALSE,
  terms = NULL,
  residuals = FALSE,
  scales = c("free", "fixed"),
  ci_level = 0.95,
  n = 100,
  n_3d = 16,
  n_4d = 4,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  constant = NULL,
  fun = NULL,
  dist = 0.1,
  rug = TRUE,
  contour = TRUE,
  grouped_by = FALSE,
  ci_alpha = 0.2,
  ci_col = "black",
  smooth_col = "black",
  resid_col = "steelblue3",
  contour_col = "black",
  n_contour = NULL,
  partial_match = FALSE,
  discrete_colour = NULL,
  discrete_fill = NULL,
  continuous_colour = NULL,
  continuous_fill = NULL,
  position = "identity",
  angle = NULL,
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  widths = NULL,
  heights = NULL,
  crs = NULL,
  default_crs = NULL,
  lims_method = "cross",
  wrap = TRUE,
  envir = environment(formula(object)),
  ...
)

eval_smoothDothilbertDotsmooth(
  smooth,
  model,
  n = 100,
  n_3d = NULL,
  n_4d = NULL,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = NULL,
  ...
)

eval_smoothDotmodDotsmooth(
  smooth,
  model,
  n = 100,
  n_3d = NULL,
  n_4d = NULL,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = NULL,
  ...
)

eval_smoothDotmoiDotsmooth(
  smooth,
  model,
  n = 100,
  n_3d = NULL,
  n_4d = NULL,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = NULL,
  ...
)
}
\arguments{
\item{object}{a fitted mvgam, the result of a call to \code{\link[=mvgam]{mvgam()}}.}

\item{trend_effects}{logical specifying whether smooth terms from the \code{trend_formula} should
be drawn. If \code{FALSE}, only terms from the observation formula are drawn. If \code{TRUE}, only
terms from the \code{trend_formula} are drawn.}

\item{data}{a data frame of covariate values at which to evaluate the
model's smooth functions.}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn.
Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{parametric}{logical; plot parametric terms also? Note that \code{select} is
used for selecting which smooths to plot. The \code{terms} argument is used to
select which parametric effects are plotted. The default, as with
\code{\link[mgcv:plot.gam]{mgcv::plot.gam()}}, is to not draw parametric effects.}

\item{terms}{character; which model parametric terms should be drawn? The
Default of \code{NULL} will plot all parametric terms that can be drawn.}

\item{residuals}{currently ignored for \code{mvgam} models.}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? If \code{scales = "free"}, the default, each univariate
smooth has its own y-axis scale. If \code{scales = "fixed"}, a common y axis
scale is used for all univariate smooths.

Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{ci_level}{numeric between 0 and 1; the coverage of credible interval.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{n_3d, n_4d}{numeric; the number of points over the range of last
covariate in a 3D or 4D smooth. The default is \code{NULL} which achieves the
standard behaviour of using \code{n} points over the range of all covariate,
resulting in \code{n^d} evaluation points, where \code{d} is the dimension of the
smooth. For \code{d > 2} this can result in very many evaluation points and slow
performance. For smooths of \code{d > 4}, the value of \code{n_4d} will be used for
all dimensions \verb{> 4}, unless this is \code{NULL}, in which case the default
behaviour (using \code{n} for all dimensions) will be observed.}

\item{unconditional}{ignored for \code{mvgam} models as all appropriate
uncertainties are already included in the posterior estimates.}

\item{overall_uncertainty}{ignored for \code{mvgam} models as all appropriate
uncertainties are already included in the posterior estimates.}

\item{constant}{numeric; a constant to add to the estimated values of the
smooth. \code{constant}, if supplied, will be added to the estimated value
before the confidence band is computed.}

\item{fun}{function; a function that will be applied to the estimated values
and confidence interval before plotting. Can be a function or the name of a
function. Function \code{fun} will be applied after adding any \code{constant}, if
provided.}

\item{dist}{numeric; if greater than 0, this is used to determine when
a location is too far from data to be plotted when plotting 2-D smooths.
The data are scaled into the unit square before deciding what to exclude,
and \code{dist} is a distance within the unit square. See
\code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}} for further details.}

\item{rug}{logical; draw a rug plot at the bottom of each plot for 1-D
smooths or plot locations of data for higher dimensions.}

\item{contour}{logical; should contours be draw on the plot using
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{grouped_by}{logical; should factor by smooths be drawn as one panel
per level of the factor (\code{FALSE}, the default), or should the individual
smooths be combined into a single panel containing all levels (\code{TRUE})?}

\item{ci_alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{ci_col}{colour specification for the confidence/credible intervals
band. Affects the fill of the interval.}

\item{smooth_col}{colour specification for the smooth line.}

\item{resid_col}{colour specification for residual points. Ignored.}

\item{contour_col}{colour specification for contour lines.}

\item{n_contour}{numeric; the number of contour bins. Will result in
\code{n_contour - 1} contour lines being drawn. See \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{select}? If \code{TRUE}, \code{select} can only be a single string to match
against.}

\item{discrete_colour}{a suitable colour scale to be used when plotting
discrete variables.}

\item{discrete_fill}{a suitable fill scale to be used when plotting
discrete variables.}

\item{continuous_colour}{a suitable colour scale to be used when plotting
continuous variables.}

\item{continuous_fill}{a suitable fill scale to be used when plotting
continuous variables.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{angle}{numeric; the angle at which the x axis tick labels are to be
drawn passed to the \code{angle} argument of \code{\link[ggplot2:guide_axis]{ggplot2::guide_axis()}}.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{widths, heights}{The relative widths and heights of each column and
row in the grid. Will get repeated to match the dimensions of the grid. If
there is more than 1 plot and \code{widths = NULL}, the value of \code{widths} will
be set internally to \code{widths = 1} to accommodate plots of smooths that
use a fixed aspect ratio.}

\item{crs}{the coordinate reference system (CRS) to use for the plot. All
data will be projected into this CRS. See \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} for
details.}

\item{default_crs}{the coordinate reference system (CRS) to use for the
non-sf layers in the plot. If left at the default \code{NULL}, the CRS used is
4326 (WGS84), which is appropriate for spline-on-the-sphere smooths, which
are parameterized in terms of latitude and longitude as coordinates. See
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} for more details.}

\item{lims_method}{character; affects how the axis limits are determined. See
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}. Be careful; in testing of some examples, changing
this to \code{"orthogonal"} for example with the chlorophyll-a example from
Simon Wood's GAM book quickly used up all the RAM in my test system and the
OS killed R. This could be incorrect usage on my part; right now the grid
of points at which SOS smooths are evaluated (if not supplied by the user)
can produce invalid coordinates for the corners of tiles as the grid is
generated for tile centres without respect to the spacing of those tiles.}

\item{wrap}{logical; wrap plots as a patchwork? If \code{FALSE}, a list of
ggplot objects is returned, 1 per term plotted.}

\item{envir}{an environment to look up the data within.}

\item{...}{additional arguments passed to other methods.}

\item{smooth}{a smooth object of class \code{"gp.smooth"} (returned from a model using either the
\code{dynamic()} function or the \code{gp()} function) or of class \code{"moi.smooth"} or \code{"mod.smooth"}
(returned from a model using the 'moi' or 'mod' basis).}

\item{model}{a fitted \code{mgcv} model of clas \code{gam} or \code{bam}.}
}
\description{
These evaluation and plotting functions exist to allow some popular \code{gratia}
methods to work with \code{mvgam} models
}
\details{
These methods allow \code{mvgam} models to be \emph{Enhanced} if users have the \code{gratia}
package installed, making available the popular \code{draw()} function to plot partial effects
of \code{mvgam} smooth functions using \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} utilities
}
\examples{
\dontrun{
# Fit a simple GAM and draw partial effects of smooths using gratia
set.seed(0)
library(ggplot2); theme_set(theme_bw())
library(gratia)
dat <- mgcv::gamSim(1, n = 200, scale = 2)
mod <- mvgam(y ~ s(x1, bs = 'moi') +
              te(x0, x2), data = dat,
             family = gaussian())

draw(mod)
}
}
\author{
Nicholas J Clark
}
