% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginaleffects.mvgam.R
\name{mvgam_marginaleffects}
\alias{mvgam_marginaleffects}
\alias{get_coef.mvgam}
\alias{set_coef.mvgam}
\alias{get_vcov.mvgam}
\alias{get_predict.mvgam}
\alias{get_data.mvgam}
\alias{get_data.mvgam_prefit}
\alias{find_predictors.mvgam}
\alias{find_predictors.mvgam_prefit}
\title{Helper functions for mvgam marginaleffects calculations}
\usage{
\method{get_coef}{mvgam}(model, trend_effects = FALSE, ...)

\method{set_coef}{mvgam}(model, coefs, trend_effects = FALSE, ...)

\method{get_vcov}{mvgam}(model, vcov = NULL, ...)

\method{get_predict}{mvgam}(model, newdata, type = "response", process_error = FALSE, ...)

\method{get_data}{mvgam}(x, source = "environment", verbose = TRUE, ...)

\method{get_data}{mvgam_prefit}(x, source = "environment", verbose = TRUE, ...)

\method{find_predictors}{mvgam}(
  x,
  effects = c("fixed", "random", "all"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion", "instruments",
    "correlation", "smooth_terms"),
  flatten = FALSE,
  verbose = TRUE,
  ...
)

\method{find_predictors}{mvgam_prefit}(
  x,
  effects = c("fixed", "random", "all"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion", "instruments",
    "correlation", "smooth_terms"),
  flatten = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{Model object}

\item{trend_effects}{\code{logical}, extract from the process model component
(only applicable if a \code{trend_formula} was specified in the model)}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?slopes} documentation for a non-exhaustive list of available
arguments.}

\item{coefs}{vector of coefficients to insert in the model object}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{newdata}{Grid of predictor values at which we evaluate the slopes.
\itemize{
\item Warning: Please avoid modifying your dataset between fitting the model and calling a \code{marginaleffects} function. This can sometimes lead to unexpected results.
\item \code{NULL} (default): Unit-level slopes for each observed value in the dataset (empirical distribution). The dataset is retrieved using \code{\link[insight:get_data]{insight::get_data()}}, which tries to extract data from the environment. This may produce unexpected results if the original data frame has been altered since fitting the model.
\item \code{\link[marginaleffects:datagrid]{datagrid()}} call to specify a custom grid of regressors. For example:
\itemize{
\item \code{newdata = datagrid(cyl = c(4, 6))}: \code{cyl} variable equal to 4 and 6 and other regressors fixed at their means or modes.
\item See the Examples section and the \code{\link[marginaleffects:datagrid]{datagrid()}} documentation.
}
\item string:
\itemize{
\item "mean": Marginal Effects at the Mean. Slopes when each predictor is held at its mean or mode.
\item "median": Marginal Effects at the Median. Slopes when each predictor is held at its median or mode.
\item "marginalmeans": Marginal Effects at Marginal Means. See Details section below.
\item "tukey": Marginal Effects at Tukey's 5 numbers.
\item "grid": Marginal Effects on a grid of representative numbers (Tukey's 5 numbers and unique values of categorical predictors).
}
}}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
first entry in the error message is used by default.}

\item{process_error}{\code{logical}. If \code{TRUE}, uncertainty in the latent
process (or trend) model is incorporated in predictions}

\item{x}{A fitted model.}

\item{source}{String, indicating from where data should be recovered. If
\code{source = "environment"} (default), data is recovered from the environment
(e.g. if the data is in the workspace). This option is usually the fastest
way of getting data and ensures that the original variables used for model
fitting are returned. Note that always the \emph{current} data is recovered from
the environment. Hence, if the data was modified \emph{after} model fitting
(e.g., variables were recoded or rows filtered), the returned data may no
longer equal the model data. If \code{source = "frame"} (or \code{"mf"}), the data
is taken from the model frame. Any transformed variables are back-transformed,
if possible. This option returns the data even if it is not available in
the environment, however, in certain edge cases back-transforming to the
original data may fail. If \code{source = "environment"} fails to recover the
data, it tries to extract the data from the model frame; if
\code{source = "frame"} and data cannot be extracted from the model frame, data
will be recovered from the environment. Both ways only returns observations
that have no missing data in the variables used for model fitting.}

\item{verbose}{Toggle messages and warnings.}

\item{effects}{Should model data for fixed effects (\code{"fixed"}), random
effects (\code{"random"}) or both (\code{"all"}) be returned? Only applies to mixed
or gee models.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned
as character vector, not as list. Duplicated values are removed.}
}
\value{
Objects suitable for internal 'marginaleffects' functions to proceed.
See \code{\link[marginaleffects:get_coef]{marginaleffects::get_coef()}}, \code{\link[marginaleffects:set_coef]{marginaleffects::set_coef()}},
\code{\link[marginaleffects:get_vcov]{marginaleffects::get_vcov()}}, \code{\link[marginaleffects:get_predict]{marginaleffects::get_predict()}},
\code{\link[insight:get_data]{insight::get_data()}} and \code{\link[insight:find_predictors]{insight::find_predictors()}} for details
}
\description{
Helper functions for mvgam marginaleffects calculations

Functions needed for working with marginaleffects

Functions needed for getting data / objects with insight
}
\author{
Nicholas J Clark
}
