% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute_with_packages.R
\name{lib.execute_using_packagelist}
\alias{lib.execute_using_packagelist}
\title{Perform operation with a certain set of packages.}
\usage{
lib.execute_using_packagelist(
  packages_to_load = c(),
  func_handle,
  ...,
  .lib_location = lib.location(),
  .pick_last = FALSE,
  .also_load_from_temp_lib = FALSE,
  .wait_for_response = TRUE,
  .run_quietly = FALSE,
  .callr_arguments = list()
)
}
\arguments{
\item{packages_to_load}{An array indicating which packages must be loaded
like "\code{c(dplyr = '0.5.0', ggplot2 = '', tidyr = '> 1.2.3')}".}

\item{func_handle}{A function object or the function name as a character string.}

\item{...}{Provide all the remaining arguments which will be arguments for the function handle.
Note that every argument must be named and must match an argument in your func_handle.}

\item{.lib_location}{The location of the version controlled library.
Defaults to lib.location(), which is the directory provided by the environment variable.}

\item{.pick_last}{Passed to \code{lib.load(packages_to_load, ...)} inside the fired \code{callr} process.}

\item{.also_load_from_temp_lib}{Passed to \code{lib.load(packages_to_load, ...)} inside the fired \code{callr} process.}

\item{.wait_for_response}{If false, it will fire and forget and return immediately
using \code{callr::r_process}, otherwise will use \code{callr::r}.}

\item{.run_quietly}{Controls the 'show' parameter of \code{callr::r} or \code{callr::r_process}.}

\item{.callr_arguments}{List specifying additional arguments for \code{callr::r} or \code{callr::r_process}
(depending on the \code{.wait_for_response} value). Note that \code{func}, \code{args},
\code{show} and \code{libpath} are already in use. Every parameter must be named.}
}
\value{
Will return the outcome of your \code{func_handle}.
}
\description{
This function can be used to perform R operations with a configured set of packages to load in a separate R process.
The package \code{callr} is required to use this functionality.
It will start a new process, then load the provided packages and execute your function.
The \code{callr} package may be provided via the R_MV_library or your standard library,
in which case it must be in a library where \code{.libPaths} is pointing to.
}
\details{
The additional arguments to callr: \code{.callr_arguments}, can for example be used
to keep a log of a detached process. By including the following
\code{.callr_arguments} for example: \cr
\preformatted{lib.execute_using_packagelist(
    ...,
    .callr_arguments   = list(stdout = paste0('./execution_', gsub('\\s|-|:', '_', format(Sys.time())), '.log'), stderr = "2>&1")
)
}
See the example below for a complete example.
When you do this, it somehow swallows the first character of every \code{stderr}
that is directly returned (also from \code{message} calls) when
\code{run_quietly = FALSE}, but the log file seems intact.
}
\section{Example}{

If you would like to log the outcomes, provide the .callr_arguments:
\preformatted{
lib.execute_using_packagelist(
    packages_to_load   = c(package.a =  '0.1.0'),
    func_handle        = function() {an_important_value(); package_a1(5, 10)},
    .wait_for_response = TRUE,
    .callr_arguments   = list(stdout = paste0('./execution_', gsub('\\s|-|:', '_', format(Sys.time())), '.log'), stderr = "2>&1"),
    .run_quietly       = TRUE
)
}
Another more simple example:
\preformatted{
lib.execute_using_packagelist(
    packages_to_load   = c(dplyr =  ''),
    func_handle        = function() {mtcars}
)
}
}

