% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute.R
\name{execute}
\alias{execute}
\alias{execute_multiverse}
\alias{execute_universe}
\title{Execute parts of, or the entire multiverse}
\usage{
execute_multiverse(multiverse, cores = getOption("mc.cores", 1L))

execute_universe(multiverse, .universe = 1)
}
\arguments{
\item{multiverse}{The multiverse object}

\item{cores}{Indicates the number of cores to use. This will execute the entire multiverse in parallel. 
Defaults to NULL (running in a single core)}

\item{.universe}{Indicate which universe to execute, if the user wants to execute a specific combination
of the parameters using `execute_universe`. Defaults to NULL, which will execute the first (default) analysis.}
}
\description{
These are functions which allow the user to execute parts or whole of the multiverse.
The user can choose to either execute the default analysis using the \code{\link{execute_universe}}, or a part or
whole of the multiverse using the \code{\link{execute_multiverse}}.
}
\details{
Each single analysis within the multiverse lives in a separate environment. 
We provide convenient functions to access the results for the  default analysis, as well as 
parts or whole of the multiverse. Each analysis can also be accessed from the multiverse table,
under the results column.
}
\examples{
\donttest{
library(dplyr)

M <- multiverse()

inside(M, {
  data <- rnorm(100, 50, 20)

  x.mean <- mean(data, trim = branch(
    trim_values,
    "trim_none" ~ 0,
    "trim_1pc" ~ 0.05,
    "trim_5pc" ~ 0.025,
    "trim_10pc" ~ 0.05
  ))
})

# Computes the analysis for all
# universes in the multiverse`
M \%>\%
  execute_multiverse()
}

}
