% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway_projector.R
\name{transfer.cross_projector}
\alias{transfer.cross_projector}
\title{Transfer from X domain to Y domain (or vice versa) in a cross_projector}
\usage{
\method{transfer}{cross_projector}(x, new_data, from, to, opts = list(), ...)
}
\arguments{
\item{x}{A \code{cross_projector} object.}

\item{new_data}{The data to transfer.}

\item{from}{Source domain ("X" or "Y").}

\item{to}{Target domain ("X" or "Y").}

\item{opts}{A list of options (see \code{transfer} generic).}

\item{...}{Ignored.}
}
\value{
Transferred data matrix.
}
\description{
Convert between data representations in a multiblock or cross-decomposition
model by projecting the input \code{new_data} from the \code{from} domain/block
onto a latent space and then reconstructing it in the \code{to} domain/block.
}
\details{
When \code{opts$ls_rr} is \code{TRUE}, the forward projection from the \code{from}
domain is computed using a ridge-regularized least squares approach.
The penalty parameter is taken from \code{opts$lambda}. Component subsetting
via \code{opts$comps} is applied after computing these ridge-based scores.
}
