% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{cdm}
\alias{cdm}
\title{centered distance matrix}
\usage{
cdm(x, normalize = TRUE, psi = NULL)
}
\arguments{
\item{x}{matrix, each row of the matrix is treated as one sample}

\item{normalize}{logical - indicates if the matrix should be normalized}

\item{psi}{the continuous negative definite function to be used. If it is \code{NULL}, the euclidean distance will be used}
}
\description{
calculates the centered distance matrix
}
\details{
Short: If \code{normalize = TRUE} then value of multivariance is comparable and meaningful. It can be compared to the \code{\link{rejection.level}} or its p-value \code{\link{multivariance.pvalue}} can be computed.

If \code{normalize = TRUE} the matrix is scaled such that the multivariance based on it, times the sample size, has in the limit - in the case of independence - the distribution of an L^2 norm of a Gaussian process with known expectation.
}
\examples{
x = coins(100)
cdm(x) # fast euclidean distances
cdm(x,psi = function(x,y) sqrt(sum((x-y)^2))) # this is identical to the previous (but slower)
}
