% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarObjectClass.R
\docType{methods}
\name{canonical.multivar}
\alias{canonical.multivar}
\alias{canonical.multivar,multivar-method}
\title{Canonical VAR Fitting Function for multivar}
\usage{
canonical.multivar(object)
}
\arguments{
\item{object}{multivar object built using \code{ConstructModel}.}
}
\value{
A list of results.
}
\description{
Canonical VAR Fitting Function for multivar
}
\details{
A function to fit a canonical VAR model to each individual dataset.
}
\examples{

# example 1 (run)
sim1  <- multivar_sim(
  k = 2,  # individuals
  d = 3,  # number of variables
  n = 20, # number of timepoints
  prop_fill_com = 0.1, # proportion of paths common
  prop_fill_ind = 0.1, # proportion of paths unique
  lb = 0.1,  # lower bound on coefficient magnitude
  ub = 0.9,  # upper bound on coefficient magnitude
  sigma = diag(1,3) # noise
)

model1 <- constructModel(data = sim1$data, weightest = "ols")
fit1 <- canonical.multivar(model1)

}
\seealso{
\code{\link{constructModel}},
}
