% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R, R/ops.R
\name{filter}
\alias{filter}
\alias{filter_}
\title{Filter data}
\usage{
filter(.self, ..., auto_compact = NULL)

filter_(.self, ..., .dots, auto_compact = NULL)
}
\arguments{
\item{.self}{Data frame}

\item{...}{Additional parameters}

\item{auto_compact}{Compact data after operation}

\item{.dots}{Workaround for non-standard evaluation}
}
\value{
Data frame
}
\description{
Select a subset of rows whose columns meet a set of criteria
}
\details{
This may be used to only include rows that match a particular set of
criteria. For example, \code{filter(x>10)} would remove any rows from
the data whose value in the x column is not greater than 10. Multiple
filtering criteria may be combined with \code{&} or \code{|}
(representing "and", "or").
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, y=rnorm(100))
dat \%>\% filter (x<50 & y>0)
dat \%>\% shutdown()
}
}
\seealso{
Other row manipulations: \code{\link{arrange}},
  \code{\link{distinct}}, \code{\link{group_by}},
  \code{\link{slice}}
}

