% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nse.R, R/ops.R
\name{summarise}
\alias{summarise}
\alias{summarise_}
\title{Summarise data}
\usage{
summarise(.self, ..., auto_compact = NULL)

summarise_(.self, ..., .dots, auto_compact = NULL)
}
\arguments{
\item{.self}{Data frame}

\item{...}{Additional parameters}

\item{auto_compact}{Compact data after operation}

\item{.dots}{Workaround for non-standard evaluation}
}
\value{
Data frame
}
\description{
Produces a summary statistic for each group or cluster node (the latter case should then be followed up with \code{reduce})
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, G=rep(c("A", "B", "C", "D"), each=25))
dat \%>\% group_by (G) \%>\% summarise (xbar = mean(x))
dat \%>\% shutdown()
}
}
\seealso{
Other data manipulations: \code{\link{mutate}},
  \code{\link{mutate_}}; \code{\link{nsa}};
  \code{\link{reduce}}, \code{\link{reduce_}};
  \code{\link{transmute}}, \code{\link{transmute_}};
  \code{\link{within_group}}; \code{\link{within_node}}
}

