% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GibbsSampler.R
\name{GibbsSampler}
\alias{GibbsSampler}
\title{This function runs the MCMC.}
\usage{
GibbsSampler(
  M.iter,
  M.burn = NULL,
  M.thin = NULL,
  model.input,
  q = NULL,
  sv = FALSE,
  every = 1000,
  WAIC = FALSE,
  param2keep = c("alpha", "beta", "gamma", "rho", "sigma", "psi")
)
}
\arguments{
\item{M.iter}{The total number of iterations in MCMC}

\item{M.burn}{The length of the burn in}

\item{M.thin}{The number to thin the chain.  Thinning by 10 only stores every 10th run.}

\item{model.input}{A list of output created by running the create.data.R function}

\item{q}{Desired number of Moran's I basis functions in the restricted spatial regression model}

\item{sv}{A TRUE/FALSE on whether or not the MCMC output should be saved as 'MCMC.Rdata' and overwritten every 1000 iterations.  Defaults to false.}

\item{every}{A number to determine how frequently MCMC output is saved along the chain.  Defaults to 1000.}

\item{WAIC}{A TRUE/FALSE on whether or not the MCMC should compute and save WAIC.  Defaults to false.}

\item{param2keep}{A character vector that governs which outputs are saved.  Permissible entries are "alpha", "beta", "gamma", "rho", "sigma", "psi", "z", "p", and "loglik"}
}
\value{
A list with all standard MCMC output
}
\description{
This function runs the MCMC.
}
\examples{
head(detection)
head(occupancy)
head(coords)
DataNames = list("species"=colnames(detection)[4:9],
"detection"=c("duration"),"occupancy"=c("forest","elev"))
model.input = multioccbuild(detection, occupancy, coords, DataNames, threshold = 15000)
out = GibbsSampler(M.iter=3, M.burn=1, M.thin=1, model.input, q=10, sv=FALSE)
}
