% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data.R
\name{set_agd_contrast}
\alias{set_agd_contrast}
\title{Set up contrast-based aggregate data}
\usage{
set_agd_contrast(
  data,
  study,
  trt,
  y = NULL,
  se = NULL,
  sample_size = NULL,
  trt_ref = NULL,
  trt_class = NULL
)
}
\arguments{
\item{data}{a data frame}

\item{study}{column of \code{data} specifying the studies, coded using integers,
strings, or factors}

\item{trt}{column of \code{data} specifying treatments, coded using integers,
strings, or factors}

\item{y}{column of \code{data} specifying a continuous outcome}

\item{se}{column of \code{data} specifying the standard error for a continuous
outcome}

\item{sample_size}{column of \code{data} giving the sample size in each arm.
Optional, see details.}

\item{trt_ref}{reference treatment for the network, as a single integer,
string, or factor. If not specified, a reasonable well-connected default
will be chosen (see details).}

\item{trt_class}{column of \code{data} specifying treatment classes, coded using
integers, strings, or factors. By default, no classes are specified.}
}
\value{
An object of class \link{nma_data}
}
\description{
Set up a network containing contrast-based aggregate data (AgD), i.e.
summaries of relative effects between treatments such as log Odds Ratios.
Multiple data sources may be combined once created using \code{\link[=combine_network]{combine_network()}}.
}
\details{
Each study should have a single reference/baseline treatment,
against which relative effects in the other arm(s) are given. For the
reference arm, include a data row with continuous outcome \code{y} equal to
\code{NA}. If a study has three or more arms (so two or more relative effects),
set the standard error \code{se} for the reference arm data row equal to the
standard error of the mean outcome on the reference arm (this determines
the covariance of the relative effects, when expressed as differences in
mean outcomes between arms).

All arguments specifying columns of \code{data} accept the following:
\itemize{
\item A column name as a character string, e.g. \code{study = "studyc"}
\item A bare column name, e.g. \code{study = studyc}
\item \code{dplyr::mutate()} style semantics for inline variable transformations, e.g. \code{study = paste(author, year)}
}

By default, \code{trt_ref = NULL} and a network reference treatment will be chosen
that attempts to maximise computational efficiency and stability. If an
alternative reference treatment is chosen and the model runs slowly or has
low effective sample size (ESS) this may be the cause - try letting the
default reference treatment be used instead. Regardless of which treatment is
used as the network reference at the model fitting stage, results can be
transformed afterwards: see the \code{trt_ref} argument of
\code{\link[=relative_effects]{relative_effects()}} and \code{\link[=predict.stan_nma]{predict.stan_nma()}}.

The \code{sample_size} argument is optional, but when specified:
\itemize{
\item Enables automatic centering of predictors (\code{center = TRUE}) in \code{\link[=nma]{nma()}}
when a regression model is given for a network combining IPD and AgD
\item Enables production of study-specific relative effects, rank probabilities,
etc. for studies in the network when a regression model is given
\item Nodes in \code{\link[=plot.nma_data]{plot.nma_data()}} may be weighted by sample size
}
}
\examples{
# Set up network of Parkinson's contrast data
head(parkinsons)

park_net <- set_agd_contrast(parkinsons,
                             study = studyn,
                             trt = trtn,
                             y = diff,
                             se = se_diff,
                             sample_size = n)

# Print details
park_net

# Plot network
plot(park_net)
}
\seealso{
\code{\link[=set_ipd]{set_ipd()}} for individual patient data, \code{\link[=set_agd_arm]{set_agd_arm()}} for
arm-based aggregate data, and \code{\link[=combine_network]{combine_network()}} for combining several
data sources in one network.

\code{\link[=print.nma_data]{print.nma_data()}} for the print method displaying details of the
network, and \code{\link[=plot.nma_data]{plot.nma_data()}} for network plots.
}
