% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit_summary-class.R
\name{plot.nodesplit_summary}
\alias{plot.nodesplit_summary}
\title{Plots of node-splitting models}
\usage{
\method{plot}{nodesplit_summary}(
  x,
  ...,
  pars = "d",
  stat = "dens_overlay",
  orientation = c("horizontal", "vertical", "y", "x"),
  ref_line = NA_real_
)
}
\arguments{
\item{x}{A \code{nodesplit_summary} object.}

\item{...}{Additional arguments passed on to the underlying \code{ggdist} plot
stat, see Details.}

\item{pars}{Character vector specifying the parameters to include in the
plot, choices include \code{"d"} for the direct, indirect, and network estimates
of relative effects, \code{"omega"} for the inconsistency factor, and \code{"tau"}
for heterogeneity standard deviation in random effects models. Default is
\code{"d"}.}

\item{stat}{Character string specifying the \code{ggdist} plot stat to use. The
default \code{"dens_overlay"} is a special case, producing an overlaid density
plot.}

\item{orientation}{Whether the \code{ggdist} geom is drawn horizontally
(\code{"horizontal"}) or vertically (\code{"vertical"}), default \code{"horizontal"}.}

\item{ref_line}{Numeric vector of positions for reference lines, by default
no reference lines are drawn.}
}
\value{
A \code{ggplot} object.
}
\description{
Produce summary plots of node-splitting models
}
\details{
Plotting is handled by \link{ggplot2} and the stats and geoms provided in
the \link{ggdist} package. As a result, the output is very flexible. Any
plotting stats provided by \code{ggdist} may be used, via the argument \code{stat}.
The default \code{"dens_overlay"} is a special exception, which uses
\code{\link[ggplot2:geom_density]{ggplot2::geom_density()}}, to plot overlaid
densities. Additional arguments in \code{...} are passed to the \code{ggdist} stat,
to customise the output.

Alternative stats can be specified to produce different summaries. For
example, specify \code{stat = "[half]eye"} to produce (half) eye plots, or \code{stat = "pointinterval"} to produce point estimates and credible intervals.

A full list of options and examples is found in the \code{ggdist} vignette
\code{vignette("slabinterval", package = "ggdist")}.

A \code{ggplot} object is returned which can be further modified through the
usual \link{ggplot2} functions to add further aesthetics, geoms, themes, etc.
}
\examples{
\donttest{
# Run smoking node-splitting example if not already available
if (!exists("smk_fit_RE_nodesplit")) example("example_smk_nodesplit", run.donttest = TRUE)
}
\donttest{
# Summarise the node-splitting results
(smk_nodesplit_summary <- summary(smk_fit_RE_nodesplit))

# Plot the node-splitting results
plot(smk_nodesplit_summary)

# Plot the inconsistency factors instead, change the plot stat to half-eye,
# and add a reference line at 0
plot(smk_nodesplit_summary, pars = "omega", stat = "halfeye", ref_line = 0)

# Plot a comparison of the heterogeneity under the node-split models vs.
# the consistency model
plot(smk_nodesplit_summary, pars = "tau")
}
}
\seealso{
\code{\link[=summary.nma_nodesplit_df]{summary.nma_nodesplit_df()}}
}
