% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_banova_mf.R
\name{rm_banova_mf}
\alias{rm_banova_mf}
\title{rm_banova_mf}
\usage{
rm_banova_mf(
  cs1,
  cs2,
  data,
  subj,
  time = TRUE,
  group = NULL,
  phase = "acquisition",
  dv = "scr",
  exclusion = "full data",
  cut_off = "full data"
)
}
\arguments{
\item{cs1}{The column name(s) of the conditioned responses for the first conditioned stimulus}

\item{cs2}{The column name(s) of the conditioned responses for the second conditioned stimulus}

\item{data}{A data frame containing all the relevant columns for the analyses}

\item{subj}{The name of the column including the participant numbers. Unique numbers are expected}

\item{time}{should time be included? Default to \code{TRUE}}

\item{group}{the name of the group, if included, default to \code{NULL}}

\item{phase}{The conditioned phase that the analyses refer to. Accepted values are  \code{acquisition}, \code{acq}, \code{extinction}, or \code{ext}}

\item{dv}{name of the measured conditioned response. Default to \code{"SCR"}}

\item{exclusion}{Name of the data reduction procedure used. Default to \code{full data}}

\item{cut_off}{cut off Name of the cut_off applied. Default to \code{full data}}
}
\value{
A tibble with the following column names:

x: the name of the independent variable (e.g., cs)

y: the name of the dependent variable as this defined in the \code{dv} argument

exclusion: see \code{exclusion} argument

model: the model that was run (e.g., rep ANOVA)

controls: ignore this column for this test

method: the model that was run

p.value: irrelevant here

effect.size: irrelevant here

effect.size.ma: irrelevant here

effect.size.lci: irrelevant here

effect.size.hci: irrelevant here

estimate: the estimate of the test run

statistic: the Bayes factor
conf.low: the lower confidence interval for the estimate

conf.high: the higher confidence interval for the estimate

framework: were the data analysed within a NHST or Bayesian framework?

data_used: a list with the data used for the specific test
}
\description{
Basic function for running the Bayesian repeated measures analysis of Variance
}
\details{
In case the \code{time} argument is set to true, the function will
include this as a within subjects factor, assuming that the columns in
\code{cs1} and \code{cs2} correspond to ascending time points (e.g., cs1
trial 1, cs1 trial 2 ... cs1 trial \code{n}). If this is not the case, the
results are not to be trusted.

The ANOVA will run *all* possible models and combinations. Please note that
in case of many factors, this will mean that the analysis will take a long
time to be completed.
}
\examples{
# Briefly define argument values that will be plugged in later on in the functions.
# We only use two trials as the function takes a long time to run.

data(example_data)
cs1 <- paste0("CSP", 1:2)
cs2 <- paste0("CSM", 1:2)
subj <- "id"

# Bayesian Repeated measures ANOVA without groups
rm_banova_mf(cs1 = cs1, cs2 = cs2, subj = subj,
data = example_data, time = TRUE)

}
