% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicross.R
\name{select_class}
\alias{select_class}
\title{When the MCM/MMCM tests reject the null, class selection can help determine which of the K classes are the likely contributors for rejection}
\usage{
select_class(data_list, level)
}
\arguments{
\item{data_list}{is list of multifeature matrices corresponding to the K different classes, so each element of the list is a matrix, for a total of K matrices.}

\item{level}{is the cutoff value (alpha) for hypothesis testing}
}
\value{
A table of pairwise comparisons among the K classes, to further probe which class influences the rejection of the null the most. No p-value adjustment is made to these reported p-values
}
\description{
When the MCM/MMCM tests reject the null, class selection can help determine which of the K classes are the likely contributors for rejection
}
\examples{
# Simulation Example when the user wants to test whether K=3 multivariate distributions are equal:
X1 = MASS::mvrnorm(10,rep(0,4),diag(2,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
X2 = MASS::mvrnorm(10,rep(0,4),diag(1,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
X3 = MASS::mvrnorm(10,rep(0,4),diag(3,4),tol=1e-6, empirical=FALSE, EISPACK=FALSE)
select_class(list(X1,X2,X3), 0.05)
}
