% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_eaf_to_mcr.R
\name{mc_eaf_to_mcr}
\alias{mc_eaf_to_mcr}
\title{Convert ELAN EAF files to a multicastR table (WIP)}
\usage{
mc_eaf_to_mcr(readfrom = getwd(), recursive = FALSE, write = FALSE,
  writeto = getwd(), filename = "")
}
\arguments{
\item{readfrom}{Directory from which to read EAF files. Defaults to the
current working directory.}

\item{recursive}{Logical. If \code{TRUE}, recurses into subdirectories.}

\item{write}{Logical. If \code{TRUE}, create an output file in \code{txt}
format.}

\item{writeto}{If \code{write} is \code{TRUE}, a directory to which to write
output. Defaults to \code{getwd}. Ignored if \code{write} is \code{FALSE}.}

\item{filename}{A length 1 character vector containing the name of the
written output. If empty, defaults to "multicast_YYMM", where 'YY' are the
last two digits of the current year and 'MM' the current month. Ignored if
\code{write} is \code{FALSE}.}
}
\value{
A \code{\link[data.table]{data.table}} of the form produced by
  \code{\link{multicast}}, containing the annotation values of the EAF files
  read.
}
\description{
\code{mc_eaf_to_mcr} converts EAF files produced by the linguistic annotation
software ELAN into a multicastR table. The EAF files must have the correct
tier structure and names, specifically those used for the Multi-CAST
collection: ...
}
\keyword{internal}
