% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicast.R
\name{multicast}
\alias{multicast}
\title{Accessing Multi-CAST annotation data}
\usage{
multicast(vkey)
}
\arguments{
\item{vkey}{A numeric or character vector of length 1 specifying the
requested version of the annotation values. Must be one of the four-digit
version keys in the first column of \code{\link{mcindex}}, or empty. If
empty, \code{multicast} defaults to the most recent version of the
annotations.}
}
\value{
A \code{\link[data.table]{data.table}} with eleven columns:
  \describe{ \item{\code{[, 1] corpus}}{The name of the corpus.}
  \item{\code{[, 2] file}}{The title of the file. A single long corpus text
  may be split into multiple files.} \item{\code{[, 3] uid}}{The utterance
  identifier. Uniquely identifies an utterance within a file.} \item{\code{[,
  4] word}}{Grammatical words. The tokenized utterances in the object
  language.} \item{\code{[, 5] gloss}}{Morphological glosses following the
  Leipzig Glossing Rules.} \item{\code{[, 6] graid}}{Annotations using the
  GRAID scheme (Haig & Schnell 2014).} \item{\code{[, 7] gform}}{The form
  symbol of a GRAID gloss.} \item{\code{[, 8] ganim}}{The person-animacy
  symbol of a GRAID gloss.} \item{\code{[, 9] gfunc}}{The function symbol of
  a GRAID gloss.} \item{\code{[, 10] refind}}{Referent tracking using the
  RefIND scheme (Schiborr et al. 2018).} \item{\code{[, 11] reflex}}{The
  information status of newly introduced referents, using a simplified
  version of the RefLex scheme (Riester & Baumann 2017).} }
}
\description{
\code{multicast} downloads the Multi-CAST annotation data from the servers of
the Language Archive Cologne (LAC) and outputs it as a
\code{\link[data.table]{data.table}}.
}
\details{
The Multi-CAST collection is amenable to extension by additional data sets
and annotation schemes. In the spirit of scientific accountability and
reproducability, \code{multicast} may take an optional argument that allows
access to previous versions of the annotation data.
}
\section{Licensing}{
 The Multi-CAST annotation data accessed by the
  \code{multicast} method is published under a \emph{Create Commons
  Attribution 4.0 International} (CC-BY 4.0) licence
  (\url{https://creativecommons.org/licenses/by-sa/4.0/}). Please refer to
  the collection documentation for information on how to give proper credit
  to its contributors.
}

\section{Citing Multi-CAST}{
 Data from the Multi-CAST collection should be
  cited as: \itemize{ \item Haig, Geoffrey & Schnell, Stefan (eds.). 2018[2015].
  \emph{Multi-CAST: Multilinguial Corpus of Annotated Spoken Texts}.
  (\url{https://lac.uni-koeln.de/en/multicast/}) (Accessed \emph{date}.) } If
  for some reason you need to cite this package on its own, please refer to
  \code{citation(multicastR)}.
}

\section{References}{
 \itemize{\item Haig, Geoffrey & Schnell, Stefan. 2014.
  \emph{Annotations using GRAID (Grammatical Relations and Animacy in
  Discourse): Introduction and guidelines for annotators.} Version 7.0.
  (\url{https://lac.uni-koeln.de/en/multicast/}) (Accessed 2018-03-14.) \item
  Riester, Arndt & Baumann, Stefan. 2017. \emph{The RefLex scheme --
  Annotation guidelines.} (SinSpeC: Working papers of the SFB 732, 14.)
  Stuttgart: University of Stuttgart.
  (\url{http://elib.uni-stuttgart.de/handle/11682/9028}) (Accessed
  2018-03-14.) \item Schiborr, Nils N. & Schnell, Stefan & Thiele, Hanna.
  2018. \emph{RefIND -- Referent Indexing in Natural-language Discourse:
  Annotation guidelines.} Version 1.0. Unpublished Manuscript. Bamberg /
  Melbourne: University of Bamberg / University of Melbourne.}
}

\examples{
# retrieve and print the most recent version of the
# Multi-CAST annotations
multicast()

# retrieve and print the version of the annotation data
# published in June 2016
multicast(1606)   # or: multicast("1606")
}
\seealso{
\code{\link{mcindex}}.
}
