% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{summary.bmult}
\alias{summary.bmult}
\title{summary method for class \code{bmult}}
\usage{
\method{summary}{bmult}(object, ...)
}
\arguments{
\item{object}{object of class \code{bmult} as returned from \code{\link{mult_bf_informed}} or \code{\link{binom_bf_informed}}}

\item{...}{additional arguments, currently ignored}
}
\value{
Invisibly returns a \code{list} which contains the Bayes factor and associated hypotheses for the full
model, but also the separate for the independent equality and inequality constraints.
\describe{The summary method returns a \code{list} with the following elements:
\item{\code{$hyp}}{Vector containing the informed hypothesis as specified by the user}
\item{\code{$bf}}{Contains Bayes factor}
\item{\code{$logmlHe}}{Contains log marginal likelihood of the encompassing model}
\item{\code{$logmlH0}}{Contains log marginal likelihood of the null model}
\item{\code{$logmlHr}}{Contains log marginal likelihood of the informed model}
\item{\code{$re2}}{Contains relative mean-square error for the Bayes factor}
\item{\code{$bf_type}}{Contains Bayes factor type as specified by the user}
\item{\code{$cred_level}}{Credible interval for the posterior point estimates.}
\item{\code{$prior}}{List containing the prior parameters.}
\item{\code{$data}}{List containing the data.}
\item{\code{$nr_equal}}{Number of independent equality-constrained hypotheses.}
\item{\code{$nr_inequal}}{Number of independent inequality-constrained hypotheses.}
\item{\code{$estimates}}{Parameter estimates for the encompassing model
\itemize{
\item \code{factor_level}: Vector with category names
\item \code{alpha}: Vector with posterior concentration parameters of Dirichlet
distribution (for multinomial models) or alpha parameters for independent beta
distributions (for binomial models)
\item \code{beta}: Vector with beta parameters for independent beta
distributions (for binomial models)
\item \code{lower}: Lower value of credible intervals of marginal beta distributions
\item \code{median}: Posterior median of marginal beta distributions
\item \code{upper}: Upper value of credible intervals of marginal beta distributions
}}
}
}
\description{
Summarizes results from Bayes factor analysis
}
\examples{
# data
x <- c(3, 4, 10, 11)
n <- c(15, 12, 12, 12)
# priors
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
# informed hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4')
Hr            <- c('theta1', '<',  'theta2', '<', 'theta3', '<', 'theta4')

## Binomial Case
out_binom  <- binom_bf_informed(x=x, n=n, Hr=Hr, a=a, b=b, niter=1e3,factor_levels, seed=2020)
summary(out_binom)
## Multinomial Case
out_mult  <- mult_bf_informed(x=x, Hr=Hr, a=a, niter=1e3,factor_levels, seed=2020)
summary(out_mult)
}
