% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sopls_results.R
\name{sopls_results}
\alias{sopls_results}
\alias{predict.sopls}
\alias{coef.sopls}
\alias{print.sopls}
\alias{summary.sopls}
\alias{pcp.sopls}
\alias{R2.sopls}
\alias{classify.sopls}
\alias{RMSEP.sopls}
\alias{cvanova.sopls}
\alias{cvanova}
\alias{classify}
\alias{pcp}
\alias{pcp.default}
\alias{cvanova.default}
\alias{print.cvanova}
\alias{summary.cvanova}
\alias{plot.cvanova}
\alias{residuals.sopls}
\title{Result functions for SO-PLS models}
\usage{
\method{predict}{sopls}(
  object,
  newdata,
  ncomp = object$ncomp,
  type = c("response", "scores"),
  na.action = na.pass,
  ...
)

\method{coef}{sopls}(object, ncomp = object$ncomp, intercept = FALSE, ...)

\method{print}{sopls}(x, ...)

\method{summary}{sopls}(
  object,
  what = c("all", "validation", "training"),
  digits = 4,
  print.gap = 2,
  ...
)

classify(object, ...)

\method{classify}{sopls}(object, classes, newdata, ncomp, LQ = "LDA", ...)

\method{R2}{sopls}(object, estimate, newdata, ncomp = "all", individual = FALSE, ...)

\method{RMSEP}{sopls}(object, estimate, newdata, ncomp = "all", individual = FALSE, ...)

pcp(object, ...)

\method{pcp}{sopls}(object, ncomp, ...)

\method{pcp}{default}(object, X, ...)

cvanova(pred, ...)

\method{cvanova}{default}(pred, true, absRes = TRUE, ...)

\method{cvanova}{sopls}(pred, comps, absRes = TRUE, ...)

\method{print}{cvanova}(x, ...)

\method{summary}{cvanova}(object, ...)

\method{plot}{cvanova}(x, ...)

\method{residuals}{sopls}(object, ...)
}
\arguments{
\item{object}{A \code{sopls} object.}

\item{newdata}{Optional new data with the same types of predictor blocks as the ones used for fitting the object.}

\item{ncomp}{An \code{integer} vector giving the exact components to apply.}

\item{type}{A \code{character} for \code{predict} indicating if responses or scores should be predicted (default = "response", or "scores"), for \code{summary} indicating which type of explained variance to compute (default = "train", alternative = "CV").}

\item{na.action}{Function determining what to do with missing values in \code{newdata}.}

\item{...}{Additional arguments. Currently not implemented.}

\item{intercept}{A \code{logical} indicating if coefficients for the intercept should be included (default = FALSE).}

\item{x}{A \code{sopls} object.}

\item{what}{A \code{character} indicating if summary should include all, validation or training.}

\item{digits}{The number of digits used for printing.}

\item{print.gap}{Gap between columns when printing.}

\item{classes}{A \code{character} vector of class labels.}

\item{LQ}{A \code{character} indicating if 'max' (maximum score value), 'lda' or 'qda' should be used when classifying.}

\item{estimate}{A \code{character} indicating if 'train', 'CV' or 'test' results should be displayed.}

\item{individual}{A \code{logical} indicating if results for individual responses should be displayed.}

\item{X}{A \code{list} of data blocks.}

\item{pred}{An object holding the CV-predicted values (\code{sopls}, \code{matrix} or \code{list} of vectors)}

\item{true}{A \code{numeric} of true response values for CVANOVA.}

\item{absRes}{A \code{logical} indicating if absolute (TRUE) or squared (FALSE) residuals should be computed.}

\item{comps}{An \code{integer} vector giving the exact components to apply.}
}
\value{
Returns depend on method used, e.g. \code{predict.sopls} returns predicted responses
or scores depending on inputs, \code{coef.sopls} return regression coefficients, while print and summary methods return the object invisibly.
}
\description{
Standard result functions for SO-PLS (\code{\link{sopls}}).
}
\details{
The parameter \code{ncomp} controls
which components to apply/extract, resulting in the sequence of components leading up to the specific choice, i.e.
\code{ncomp = c(2,2,1)} results in the sequence 1,0,0; 2,0,0; 2,1,0; 2,2,0; 2,2,1.
Usage of the functions are shown using generics in the examples below.
Prediction, regression coefficients, object printing and summary are available through:
\code{predict.sopls}, \code{coef.sopls}, \code{print.sopls} and \code{summary.sopls}.
Explained variances and RMSEP are available through \code{R2.sopls} and \code{RMSEP.sopls}.
Principal components of predictions are available through \code{pcp.sopls}. Finally, there is work in progress on classifcation
support through \code{classify.sopls}.
}
\examples{
data(potato)
mod <- sopls(Sensory[,1] ~ ., data = potato[c(1:3,9)], ncomp = 5, subset = 1:20)
testset <- potato[-(1:20),]; testset$Sensory <- testset$Sensory[,1,drop=FALSE]
predict(mod, testset, ncomp=c(2,1,2))
dim(coef(mod, ncomp=c(3,0,1))) # <variables x responses x components>
R2(mod, ncomp = c(4,1,2))
print(mod)
summary(mod)

# PCP from sopls object
modMulti <- sopls(Sensory ~ ., data = potato[c(1:3,9)], ncomp = 5, validation = "CV", segment = 5)
(PCP <- pcp(modMulti, c(2,1,2)))
scoreplot(PCP)

# PCP from matrices
preds <- modMulti$validation$Ypred[,,"2,1,2"]
PCP_default <- pcp(preds, potato[1:3])

# CVANOVA
modCV <- sopls(Sensory[,1] ~ ., data = potato[c(1:3,9)], ncomp = 5, validation = "CV", segment = 5)
summary(cva <- cvanova(modCV, "2,1,2"))
plot(cva)

}
\references{
Jørgensen K, Mevik BH, Næs T. Combining designed experiments with several blocks of spectroscopic data. Chemometr Intell Lab Syst. 2007;88(2): 154–166.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for plotting are found in \code{\link{sopls_plots}}.
}
