% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankedBasedTest.R
\docType{class}
\name{gsea-class}
\alias{gsea-class}
\alias{gsea}
\alias{run_test,gsea-method}
\title{Gene Set Enrichment Analysis (GSEA)}
\usage{
\S4method{run_test}{gsea}(model)
}
\arguments{
\item{model}{Object of S4 class representing the mulea test.}
}
\value{
GSEA object. This object represents the result of the
\code{gsea} tests.

run_test method for GSEA object. Returns results of
the enrichment analysis.
}
\description{
An S4 class to represent the gsea tests in mulea.
}
\section{Methods (by generic)}{
\itemize{
\item \code{run_test(gsea)}: runs test calculations.

}}
\section{Slots}{

\describe{
\item{\code{gmt}}{A \code{data.frame} representing the ontology GMT.}

\item{\code{element_names}}{A vector of elements names
(gene or protein names or identifiers) to include in the analysis.}

\item{\code{element_scores}}{A vector of numeric values representing a
score (\emph{e.g.} \emph{p}-value, \emph{z}-score, log fold change) for each
'element_name', in the same number and order as element_name.}

\item{\code{gsea_power}}{A power of weight. Default value is 1.}

\item{\code{element_score_type}}{Defines the GSEA score type.
\itemize{
\item 'pos': Only positive element_scores
\item 'neg': Only negative element_scores
\item 'std': standard, containing both positive and negative scores
Default value is 'std'.
}}

\item{\code{number_of_permutations}}{The number of permutations used in
\code{gsea} test. Default value is 1000.}

\item{\code{test}}{character}
}}

\examples{
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(
    package="mulea", "extdata",
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
    max_nr_of_elements = 400)

# loading the example `data.frame`
scored_gene_tab <- read.delim(file = system.file(package = "mulea", "extdata", 
        "ordered_set.tsv"))

# creating the GSEA model
gsea_model <- gsea(gmt = tf_gmt_filtered,
        # the names of elements to test
        element_names = scored_gene_tab$Gene.symbol,
        # the logFC-s of elements to test
        element_scores = scored_gene_tab$logFC,
        # consider elements having positive logFC values only
        element_score_type = "pos",
        # the number of permutations
        number_of_permutations = 10000)
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(package="mulea", "extdata", 
        "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
        max_nr_of_elements = 400)

# loading the example `data.frame`
scored_gene_tab <- read.delim(file = system.file(package = "mulea", "extdata", 
        "ordered_set.tsv"))

# creating the GSEA model
gsea_model <- gsea(gmt = tf_gmt_filtered,
        # the names of elements to test
        element_names = scored_gene_tab$Gene.symbol,
        # the logFC-s of elements to test
        element_scores = scored_gene_tab$logFC,
        # consider elements having positive logFC values only
        element_score_type = "pos",
        # the number of permutations
        number_of_permutations = 10000)

# running the test
gsea_results <- run_test(gsea_model)
}
