% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{write_gmt}
\alias{write_gmt}
\title{Write GMT file}
\usage{
write_gmt(gmt, file)
}
\arguments{
\item{gmt}{A \code{data.frame} containing the data to be written,
imported from a GMT file with the \code{read_gmt} function.}

\item{file}{Character, a path to a file.}
}
\value{
Returns the input as a GMT file at a specific location.
}
\description{
Writes gene set or ontology \code{data.frame} with specific
formatting (columns representing ontology identifiers, descriptions, and
associated lists of values) and writes it to a file in a standardized Gene
Matrix Transposed (GMT) file format.
}
\examples{
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(
    package="mulea", "extdata", 
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))

# writing the filtered ontology to a GMT file
\donttest{
write_gmt(
    gmt = tf_gmt, 
    file = "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt")
}
}
