% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mudens.R
\name{summary.mudens}
\alias{summary.mudens}
\title{Display the most important input parameters used in calling the 'mudens' function}
\usage{
\method{summary}{mudens}(object, ...)
}
\arguments{
\item{object}{object of class \code{mudens} (output from calling \code{mudens(.)} function)}

\item{...}{Additional arguments to be passed along.}
}
\value{
The summary result for mudens estimation
}
\description{
It also displays some of the output data. Common to all three methods:
             (1) number of observations, (2) number of censored observations, (3) bandwidth method
             used (global, local or nearest neighbor), (4) boundary correction type (none, left only,
             both left and right), (5) kernel type (rectangle, Epanechnikov, biquadradic, triquadratic),
             (6) minimum time, (7) maximum time, (8) number of points in MSE minimization grid,
             (9) number of points in estimation grid, (10) pilot bandwidth,
             (11) estimated IMSE for optimal bandwidth.

 This function will also report the following two results
 for different selections of methods: (12) Smoothing Bandwidth and
 (13) Optimal Number of Nearest Neighbor.
 If \code{bw.method="global"}, this function will display the optimal global bandwidth.
 If \code{bw.method="knn"}, it will show optimal number of nearest neighbors.
 If \code{bw.method="local"} and \code{bw.method="knn"}, the
 summary result will include the smoothing bandwidth used to smooth the optimal local bandwidths.
}
\details{
Display the most important input parameters used in calling the 'mudens' function
}
\references{
Hess, K.R. and Zhong, M. Density Function Estimation for Possibly Right-Censored Data Using Kernel Functions. Submitted.
}
\seealso{
\link{mudens}
}
\author{
Kenneth R. Hess
}
