% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata_helpers.R
\name{distinct_params}
\alias{distinct_params}
\alias{distinct_params.default}
\alias{distinct_locations}
\alias{distinct_locations.default}
\alias{distinct_datasets}
\alias{distinct_datasets.default}
\alias{distinct_columns}
\alias{distinct_columns.default}
\alias{src_tbls.mudata}
\title{Get distinct params, locations, and datasets from a mudata object}
\usage{
distinct_params(x, ...)

\method{distinct_params}{default}(x, table = "data", ...)

distinct_locations(x, ...)

\method{distinct_locations}{default}(x, table = "data", ...)

distinct_datasets(x, ...)

\method{distinct_datasets}{default}(x, table = "data", ...)

distinct_columns(x, ...)

\method{distinct_columns}{default}(x, table = names(x), ...)

\method{src_tbls}{mudata}(x, ...)
}
\arguments{
\item{x}{A mudata object}

\item{...}{Passed to other methods}

\item{table}{The table to use to calculate the distinct values. Using
the "data" table is safest, but for large datasets that are not
in memory, using the meta table (params, locations, or datasets)
may be useful.}
}
\value{
A character vector of distinct parameter names
}
\description{
Get distinct params, locations, and datasets from a mudata object
}
\examples{
distinct_params(kentvillegreenwood)
distinct_locations(kentvillegreenwood)
distinct_datasets(kentvillegreenwood)
}
