% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstSIB.R
\name{mstSIB}
\alias{mstSIB}
\title{The mstSIB test for MSTs}
\usage{
mstSIB(
  resp,
  DIF_covariate,
  theta = NULL,
  see = NULL,
  cellmin = 3,
  pctmin = 0.9,
  NCell = 80
)
}
\arguments{
\item{resp}{A data frame containing the response matrix. Rows correspond to respondents, columns to items.}

\item{DIF_covariate}{A vector indicating the membership to the reference (0) and focal (1) groups.}

\item{theta}{A vector of ability estimates for each respondent.}

\item{see}{A vector of the standard error of the ability estimates for each respondent.}

\item{cellmin}{Minimum number of respondents per cell for the focal and reference group. Cells with fewer respondents are discarded.}

\item{pctmin}{Minimum rate of focal and reference group that should be used for estimating the over ability difference between focal and groups after discarding cells with few respondents.}

\item{NCell}{The initial number of cells for estimating the overall ability difference between the focal and reference groups.}
}
\value{
A list with four elements. The first element is the response matrix, the second element is the name of
the DIF covariate, and the third element is the name of the test. The fourth element is a matrix where each
row corresponds to an item. The columns correspond to the following entries:
\describe{
  \item{Beta}{The estimated weighted ability difference between the focal and reference groups.}
  \item{Vars}{The estimation error of the weighted ability difference between the focal and reference groups.}
  \item{N_R}{The number of respondents in the reference group.}
  \item{N_F}{The number of respondents in the focal group.}
  \item{NCell}{The initial number of cells for estimating the overall ability
  difference between the focal and reference groups.}
  \item{p_value}{The p-value of the null hypothesis that the ability difference
  between the focal and reference groups is 0.}
  }
}
\description{
This function allows the detection of itemwise DIF using the mstSIB test.
}
\details{
Author: Mark J. Gierl, with minor changes by Rudolf Debelak and Dries Debeer
}
\examples{
data("toydata")
resp <- toydata$resp
group_categ <- toydata$group_categ
theta_est <- toydata$theta_est
see_est <- toydata$see_est
mstSIB(resp = as.data.frame(resp), theta = theta_est,
DIF_covariate = group_categ, see = see_est)

}
