% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mssm.R
\name{mssm-pf}
\alias{mssm-pf}
\title{Particle Filter Function for Multivariate State Space Model}
\arguments{
\item{cfix}{values for for coefficient for the fixed effects.}

\item{disp}{additional parameters for the family (e.g., a dispersion
parameter).}

\item{F.}{matrix in the transition density of the state vector.}

\item{Q}{covariance matrix in the transition density of the state vector.}

\item{Q0}{optional covariance matrix at the first time point. Default is
the covariance matrix in the time invariant distribution.}

\item{mu0}{optional mean at the first time point. Default is
the zero vector.}

\item{trace}{integer controlling whether information should be printed
during particle filtering. Zero yields no information.}

\item{seed}{integer to pass to \code{\link{set.seed}}. The seed is not set
if the argument is \code{NULL}.}

\item{what, N_part}{same as in \code{\link{mssm_control}}.}
}
\value{
An object of class \code{mssm} with the following elements
\item{pf_output}{A list with an element for each time period. Each element
is a list with
\code{particles}: the sampled particles,
\code{stats}: additional object that is requested to be computed with
each particle,
\code{ws:} unnormalized log particle weights for the filtering distribution,
and
\code{ws_normalized:} normalized log particle weights for the filtering
distribution.}

Remaining elements are the same as returned by \code{\link{mssm}}.

If gradient approximation is requested then the first elements of
\code{stats} are w.r.t. the fixed coefficients, the next elements are
w.r.t. the matrix in the map from the previous state vector to the mean
of the next, and the last element is w.r.t. the covariance matrix.
Only the lower triangular matrix is kept for the covariance
matrix. See the examples in the README at
\url{https://github.com/boennecd/mssm}. There will be an additional
element for the dispersion parameter if the family has a dispersion
parameter.

If the Hessian is requested then the \eqn{\tilde \beta_n^{(i)}}s
in Poyiadjis et al. (2011) are returned after the gradient elements. These
can be used to approximate the observed information matrix. That is,
using that the approximation of the observed information matrix is

\deqn{\tilde S_n\tilde S_n^\top - \sum_{i = 1}^n
   \tilde W_n^{(i)}(\tilde\alpha_n^{(i)}\tilde\alpha_n^{(i)\top} +
   \tilde \beta_n^{(i)}),
   \qquad \tilde S_n = \sum_{i=1}^n \tilde W_n^{(i)}\tilde\alpha_n^{(i)}}

as in Poyiadjis et al. (2011). See the README for an example.
}
\description{
Function returned from \code{\link{mssm}} which can be used to perform
particle filtering given values for the parameters in the model.
}
\examples{
if(require(Ecdat)){
  # load data and get object to perform particle filtering
  data("Gasoline", package = "Ecdat")

  library(mssm)
  ll_func <- mssm(
    fixed = lgaspcar ~ factor(country) + lincomep + lrpmg + lcarpcap,
    random = ~ 1, family = Gamma("log"), data = Gasoline, ti = year,
    control = mssm_control(N_part = 1000L, n_threads = 1L))

  # run particle filter
  cfix <- c(0.612, -0.015, 0.214, 0.048, -0.013, -0.016, -0.022, 0.047,
            -0.046, 0.007, -0.001, 0.008, -0.117, 0.075, 0.048, -0.054, 0.017,
            0.228, 0.077, -0.056, -0.139)
  pf <- ll_func$pf_filter(
    cfix = cfix, Q = as.matrix(2.163e-05), F. = as.matrix(0.9792),
    disp = 0.000291)
  print(pf)
}
}
\references{
Poyiadjis, G., Doucet, A. and Singh, S. S. (2011) Particle Approximations of
the Score and Observed Information Matrix in State Space Models with
Application to Parameter Estimation. \emph{Biometrika}, \strong{98(1)},
65--80.
}
\seealso{
\code{\link{mssm}}.
}
