% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment}
\alias{augment}
\title{A fast and general method for building augmented data.}
\usage{
augment(data, data_key, n_events, pattern, state = list("IN", "OUT", "DEAD"),
  t_start, t_end, t_cens, t_death, t_augmented = "augmented", more_status,
  verbose = TRUE)
}
\arguments{
\item{data}{A \code{data.table} object where each row represents an observation.}

\item{data_key}{A keying variable which \code{augment} uses to define a key for \code{data}.
This represents the subject ID.}

\item{n_events}{An integer variable indicating the progressive (monotonic) event number
of a given ID. If missing, \code{augment} fastly creates a variable named \code{"n_events"}.
\code{augment} always checks whether \code{n_events} is monotonic increasing within the
provided \code{data_key} and stops the execution in case the check fails (see 'Details').}

\item{pattern}{Either an integer, a factor or a characer with 2 or 3 unique values which
provides the ID status at the end of the study. \code{pattern} has a predefined structure.
When 2 values are detected, they must be in the format: 0 = "alive", 1 = "dead". When 3 values
are detected, then the format must be: 0 = "alive", 1 = "dead during a transition",
2 = "dead after a transition has ended".}

\item{state}{A list of 3 possible states which a subject can reach. \code{state} has a predefined
structure as follows: IN, OUT, DEAD. If \code{augment} does not detect exactly 3 states, it
stops with error.}

\item{t_start}{The starting time of an observation. It can be passed as date, integer, or numeric
format.}

\item{t_end}{The ending time of an observation. It can be passed as date, integer, or numeric
format.}

\item{t_cens}{The censoring time of the study}

\item{t_death}{The exact death time of a subject ID. If \code{t_death} is missing,
\code{t_cens} is assumed to contain both censoring and death time.}

\item{t_augmented}{The new time variable of the process in the augmented format.
If \code{t_augmented} is missing, then the default name 'augmented' is assumed.
The variable is added to \code{data}. If \code{augment} detects a date or a difftime
format in \code{t_start}, then \code{t_augmented} is cast to integer or to numeric, respectively,
into a new variable with the suffix '_int' or '_num' added to \code{t_augmented}
This is done because \code{\link[msm]{msm}} can't deal correclty if time variable is a date
or a difftime. Both variables are positioned before \code{t_start}.}

\item{more_status}{A variable which marks further transitions beside the default given by
\code{state}. \code{more_status} can be a factor or a character. In particular, if the
corresponding observation is a standard admission (i.e. no other information available), then
\code{more_status} must be set to 'df' which stands for 'Default' (see 'Examples' and ?hosp).
If missing, \code{augment} ignores it.}

\item{verbose}{If \code{FALSE}, all information produced by \code{print}, \code{cat} and
\code{message} are suppressed. All is done internally so that no global
options are changed. \code{verbose} can be set to \code{FALSE} on all common OS
(see also \code{\link[base]{sink}} and \code{\link[base]{options}}). Default is \code{TRUE}.}
}
\value{
A restructured long format dataset of class \code{"data.table"} where each row
represents a specific transition for a given subject. Moreover, \code{augment} adds some
important variables:\cr
-----\cr
\emph{augmented}: the new timing variable for the process when looking at transitions. If
\code{t_augmented} is missing, then \code{augment} creates \emph{augmented} by default.
\emph{augmented}. The function looks directly to \code{t_start} and \code{t_end} to build
it and thus it inherits their class.
In particular, if \code{t_start} is a date format, then \code{augment} computes a new variable
cast as integer and names it \emph{augmented_int}. If \code{t_start} is a difftime format,
then \code{augment} computes a new variable cast as a numeric and names it \emph{augmented_num};\cr
\emph{status}: a status flag which looks at \code{state}. \code{augment} automatically checks
whether argument \code{pattern} has 2 or 3 unique values and computes the correct structure of
a given subject. The variable is cast as character;\cr
\emph{status_num}: the corresponding integer version of \emph{status};\cr
\emph{n_status}: a mix of \emph{status} and \code{n_events} cast as character.
\emph{n_status} comes into play when a model on the progression of the process is intended.\cr
-----\cr

If \code{more_status} is passed, then \code{augment} computes some more variables. They mimic the
meaning of \emph{status}, \emph{status_num}, and \emph{n_status} but they account for the more
complex structure defined. They are: \code{status_exp}, \code{status_exp_num}, and
\code{n_status_exp}.
}
\description{
A fast and general method for reshaping standard longitudinal data, where each observation contains
the exact starting and ending time of the process, into a new structure called 'augmented'
which is suitable for multi-state analyses using the \code{\link[msm]{msm}} package.
}
\details{
In order to get the data processed, a monotonic increasing process needs to be ensured.
\code{augment} checks this both in case \code{n_events} is missing or not. The data are
fastly ordered through \code{\link[data.table]{setkey}} function and using \code{data_key} as
the primary key and \code{t_start} as secondary key. Then it checks \code{n_events} and if it fails,
it returns the subjects gived by \code{data_key} where issues occurred before giving an
error and stopping. If \code{n_events} is not passed, then the ordering procedure remains the
same, but the progression number is created internally with the name \code{n_events}.
}
\examples{
# 1.
# loading data
data( hosp )

# augmenting hosp
hosp_augmented = augment( data = hosp, data_key = subj, n_events = adm_number, pattern = label_3,
                          t_start = dateIN, t_end = dateOUT, t_cens = dateCENS )

# 2.
# augmenting hosp by passing more information regarding transition with arg. more_status
hosp_augmented_more = augment( data = hosp, data_key = subj, n_events = adm_number,
                               pattern = label_3, t_start = dateIN, t_end = dateOUT,
                               t_cens = dateCENS, more_status = rehab_it )

\dontrun{
augmented = augment( data = hosp, data_key = subj, n_events = dateIN,
                     pattern = label_3, t_start = dateIN, t_end = dateOUT, t_cens = dateCENS ) }
}
\author{
Francesco Grossetti \email{francesco.grossetti@polimi.it}.
}
\references{
Jackson, C.H. (2011). Multi-State Models for Panel Data:
The \emph{msm} Package for R. Journal of Statistical Software, 38(8), 1-29.
URL \url{http://www.jstatsoft.org/v38/i08/}.
}

