% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{msigdbr}
\alias{msigdbr}
\title{Retrieve the msigdbr data frame}
\usage{
msigdbr(species = "Homo sapiens", category = NULL, subcategory = NULL)
}
\arguments{
\item{species}{Species name, such as Homo sapiens or Mus musculus. The available species can be retrieved with \code{msigdbr_show_species()}.}

\item{category}{MSigDB collection abbreviation, such as H, C1, C2, C3, C4, C5, C6, C7.}

\item{subcategory}{MSigDB sub-collection abbreviation, such as CGP or BP.}
}
\value{
A data frame of gene sets with one gene per row.
}
\description{
Retrieve the msigdbr data frame
}
\examples{
# get all human gene sets
\donttest{msigdbr(species = "Homo sapiens")}

# get mouse C2 (curated) CGP (chemical and genetic perturbations) gene sets
\donttest{msigdbr(species = "Mus musculus", category = "C2", subcategory = "CGP")}

# check all the available categories and sub-categories
\donttest{msigdbr() \%>\% dplyr::distinct(gs_cat, gs_subcat) \%>\% dplyr::arrange(gs_cat, gs_subcat)}
}
\references{
\url{https://www.gsea-msigdb.org/gsea/msigdb/collections.jsp}
}
