% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{msgl.algorithm.config}
\alias{msgl.algorithm.config}
\title{Create a new algorithm configuration}
\usage{
msgl.algorithm.config(tolerance_penalized_main_equation_loop = 1e-10,
  tolerance_penalized_inner_loop_alpha = 1e-04,
  tolerance_penalized_inner_loop_beta = 1,
  tolerance_penalized_middel_loop_alpha = 0.01,
  tolerance_penalized_outer_loop_alpha = 0.01,
  tolerance_penalized_outer_loop_beta = 0,
  tolerance_penalized_outer_loop_gamma = 1e-05,
  use_bound_optimization = TRUE,
  use_stepsize_optimization_in_penalizeed_loop = TRUE,
  stepsize_opt_penalized_initial_t = 1, stepsize_opt_penalized_a = 0.1,
  stepsize_opt_penalized_b = 0.1, max_iterations_outer = 1e+05,
  inner_loop_convergence_limit = 1e+05, verbose = TRUE)
}
\arguments{
\item{tolerance_penalized_main_equation_loop}{tolerance threshold.}

\item{tolerance_penalized_inner_loop_alpha}{tolerance threshold.}

\item{tolerance_penalized_inner_loop_beta}{tolerance threshold.}

\item{tolerance_penalized_middel_loop_alpha}{tolerance threshold.}

\item{tolerance_penalized_outer_loop_alpha}{tolerance threshold.}

\item{tolerance_penalized_outer_loop_beta}{tolerance threshold.}

\item{tolerance_penalized_outer_loop_gamma}{tolerance threshold.}

\item{use_bound_optimization}{if \code{TRUE} hessian bound check will be used.}

\item{use_stepsize_optimization_in_penalizeed_loop}{if \code{TRUE} step-size optimization will be used.}

\item{stepsize_opt_penalized_initial_t}{initial step-size.}

\item{stepsize_opt_penalized_a}{step-size optimization parameter.}

\item{stepsize_opt_penalized_b}{step-size optimization parameter.}

\item{max_iterations_outer}{max iteration of outer loop}

\item{inner_loop_convergence_limit}{inner loop convergence limit.}

\item{verbose}{If \code{TRUE} some information, regarding the status of the algorithm, will be printed in the R terminal.}
}
\value{
A configuration.
}
\description{
With the exception of \code{verbose} it is not recommended to change any of the default values.
}
\examples{
data(SimData)

# A quick look at the data
dim(x)
table(classes)

# Create configuration
config <- msgl.algorithm.config(verbose = FALSE)

lambda <- msgl::lambda(x, classes, alpha = .5, d = 50,
 lambda.min = 0.05, algorithm.config = config)

fit <- msgl::fit(x, classes, alpha = .5, lambda = lambda,
 algorithm.config = config)

}
\author{
Martin Vincent
}
