% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sde.examples.R
\name{sde.examples}
\alias{sde.examples}
\title{Example SDE models.}
\usage{
sde.examples(model = c("hest", "pgnet", "lotvol", "biou"),
  file.only = FALSE)
}
\arguments{
\item{model}{Character string giving the name of a sample model.  Possible values are: \code{hest}, \code{pgnet}, \code{lotvol}, \code{biou}.  See Details.}

\item{file.only}{If \code{TRUE} returns only the path to the header file containing the \code{sdeModel} object implementation.}
}
\value{
An \code{sde.model} object, or the path to the C++ model header file.
}
\description{
Provides sample \code{C++} code for several SDE models.
}
\details{
All pre-compiled models are with the default prior and with \code{OpenMP} disabled.  A full description of the example models can be found in the package vignette; to view it run \code{vignette("msde-exmodels")}.
}
\examples{
# Heston's model
hmod <- sde.examples("hest") # load pre-compiled model

# inspect model's C++ code
hfile <- sde.examples("hest", file.only = TRUE)
cat(readLines(hfile), sep = "\\n")

\dontrun{
# compile it from scratch
param.names <- c("alpha", "gamma", "beta", "sigma", "rho")
data.names <- c("X", "Z")
hmod <- sde.make.model(ModelFile = hfile,
                       param.names = param.names,
                       data.names = data.names)
}
}
\seealso{
\code{\link{sde.make.model}} for \code{sde.model} objects, \code{\link{mvn.hyper.check}} for specification of the default prior.
}
