% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/class_tgrid.R
\docType{class}
\name{stime}
\alias{stime}
\alias{tgrid-class}
\alias{tgrids-class}
\title{Get the times at which the model will be evaluated}
\usage{
stime(x, ...)
}
\arguments{
\item{x}{object of class mrgmod}

\item{...}{passed on}
}
\value{
a sorted vector of unique times
}
\description{
Get the times at which the model will be evaluated
}
\details{
Simulation times include the sequence of times created from 
\code{start}, \code{end}, and \code{delta} and the vector of times
found in \code{add}.  Making \code{end} negative will omit any 
\code{start} / \code{end} / \code{delta} sequence.  Negative values 
are discarded from the result.
}
\examples{

## example("stime", package="mrgsolve")

mod <- mrgsolve:::house(end=12, delta=2, add=c(11,13,15))

stime(mod)


}
\keyword{internal}
