% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/class_mrgmod.R, R/events.R,
%   R/mrgsims.R
\docType{methods}
\name{events}
\alias{events}
\alias{ev}
\alias{as.ev}
\alias{events,mrgmod-method}
\alias{ev,mrgmod-method}
\alias{ev,missing-method}
\alias{ev,ev-method}
\alias{as.ev,data.frame-method}
\alias{as.ev,ev-method}
\alias{as.matrix,ev-method}
\alias{as.data.frame,ev-method}
\alias{show,ev-method}
\alias{events,mrgsims-method}
\title{Event objects for simulating PK and other interventions.}
\usage{
events(x, ...)

ev(x, ...)

as.ev(x, ...)

\S4method{events}{mrgmod}(x, ...)

\S4method{ev}{mrgmod}(x, object = NULL, ...)

\S4method{ev}{missing}(time = 0, evid = 1, ID = numeric(0), cmt = 1,
  replicate = TRUE, until = NULL, realize_addl = FALSE, ...)

\S4method{ev}{ev}(x, realize_addl = FALSE, ...)

\S4method{as.ev}{data.frame}(x, nid = 1, keep_id = TRUE, ...)

\S4method{as.ev}{ev}(x, ...)

\S4method{as.matrix}{ev}(x, ...)

\S4method{as.data.frame}{ev}(x, row.names = NULL, optional = FALSE, ...)

\S4method{show}{ev}(object)

\S4method{events}{mrgsims}(x, ...)
}
\arguments{
\item{x}{mrgmodel object}

\item{...}{passed on}

\item{object}{passed to show}

\item{time}{event time}

\item{evid}{event ID}

\item{ID}{subject ID}

\item{cmt}{compartment}

\item{replicate}{logical; if \code{TRUE}, events will be replicated for 
each individual in \code{ID}}

\item{until}{the expected maximum \bold{observation} time for this regimen}

\item{realize_addl}{if \code{FALSE} (default), no change to \code{addl} doses. 
 If \code{TRUE}, 
\code{addl} doses are made explicit with \code{\link{realize_addl}}.}

\item{nid}{if greater than 1, will expand to the appropriate 
number of individuals}

\item{keep_id}{if \code{TRUE}, \code{ID} column is retained if it exists}

\item{row.names}{passed to \code{\link{as.data.frame}}}

\item{optional}{passed to \code{\link{as.data.frame}}}
}
\value{
Returns a user-defined data frame of events that should be suitable
for passing into \code{lsoda}.  If events are stored as a data frame,
\code{events} returns the data frame.  If events are stored as a function
that generates the data frame, \code{events} calls the function and passes
return back to the user.

events object
}
\description{
Events can either be specified when the model object is created (with
\code{mrgmod}) or by updating an existing model object (with \code{update}).
}
\details{
\itemize{
\item Required input for creating events objects include \code{time} and \code{cmt}
\item If not supplied, \code{evid} is assumed to be 1.
\item If not supplied, \code{cmt}  is assumed to be 1.
\item If not supplied, \code{time} is assumed to be 0.
\item \code{ID} may be specified as a vector.
\item If replicate is \code{TRUE} (default), thenthe events regimen is replicated for each \code{ID}; otherwise, the number of
event rows must match the number of \code{ID}s entered
}
}
\examples{
mod <- mrgsolve:::house()
mod <- mod \%>\% ev(amt=1000, time=0, cmt=1)
events(mod)

loading <- ev(time=0, cmt=1, amt=1000)
maint <- ev(time=12, cmt=1, amt=500, ii=12, addl=10)
loading + maint


ev(ID=1:10, cmt=1, time=0, amt=100)


}
