% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{ev_assign}
\alias{ev_assign}
\alias{assign_ev}
\title{Replicate a list of events into a data set.}
\usage{
ev_assign(l, idata, evgroup, join = FALSE)

assign_ev(...)
}
\arguments{
\item{l}{list of event objects}

\item{idata}{an idata set (one ID per row)}

\item{evgroup}{the character name of the column in \code{idata} 
that specifies event object to implement}

\item{join}{if \code{TRUE}, join \code{idata} to the data set 
before returning.}

\item{...}{used to pass arguments from \code{assign_ev}
to \code{ev_assign}}
}
\description{
Replicate a list of events into a data set.
}
\examples{
ev1 <- ev(amt=100)
ev2 <- ev(amt=300, rate=100, ii=12, addl=10)

idata <- data.frame(ID=1:10) 
idata$arm <- 1+(idata$ID \%\%2)

ev_assign(list(ev1,ev2),idata,"arm",join=TRUE)

}
