% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcds.R
\name{mcds}
\alias{mcds}
\title{MCDS function definition}
\usage{
mcds(
  formula = NULL,
  key = NULL,
  adj.series = NULL,
  adj.order = c(NULL),
  adj.scale = "width",
  adj.exp = FALSE,
  shape.formula = ~1
)
}
\arguments{
\item{formula}{formula for scale function}

\item{key}{string identifying key function (currently either "hn"
(half-normal),"hr" (hazard-rate), "unif" (uniform) or "gamma" (gamma
distribution)}

\item{adj.series}{string identifying adjustment functions cos (Cosine), herm
(Hermite polynomials), poly (simple polynomials) or NULL}

\item{adj.order}{vector of order of adjustment terms to include}

\item{adj.scale}{whether to scale the adjustment terms by "width" or "scale"}

\item{adj.exp}{if TRUE uses exp(adj) for adjustment to keep f(x)>0}

\item{shape.formula}{formula for shape function}
}
\value{
A formula list used to define the detection function model
  \item{fct}{string "mcds"} \item{key}{key function string}
  \item{adj.series}{adjustment function string} \item{adj.order}{adjustment
  function orders} \item{adj.scale}{adjustment function scale type}
  \item{formula}{formula for scale function} \item{shape.formula}{formula
  for shape function}
}
\description{
Creates model formula list for multiple covariate distance sampling using
values supplied in call to \code{\link{ddf}}
}
\author{
Jeff Laake; Dave Miller
}
\keyword{utility}
