% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.det.tables.R
\name{plot.det.tables}
\alias{plot.det.tables}
\title{Observation detection tables}
\usage{
\method{plot}{det.tables}(
  x,
  which = 1:6,
  angle = NULL,
  density = NULL,
  col1 = "white",
  col2 = "lightgrey",
  new = TRUE,
  ...
)
}
\arguments{
\item{x}{object returned by \code{\link{det.tables}}}

\item{which}{items in x to plot (vector with values in 1:6)}

\item{angle}{shading angle for hatching}

\item{density}{shading density for hatching}

\item{col1}{plotting colour for total histogram bars.}

\item{col2}{plotting colour for subset histogram bars.}

\item{new}{if \code{TRUE} new plotting window for each plot}

\item{\dots}{other graphical parameters, passed to plotting functions}
}
\value{
Just plots.
}
\description{
Plot the tables created by \code{\link{det.tables}}. Produces a series of
tables for dual observer data that shows the number missed and detected for
each observer within defined distance classes.
}
\details{
Plots that are produced are as follows (controlled by the \code{which} argument):
\describe{
  \item{1}{Detected by either observer/Detected by observer 1}
  \item{2}{Detected by either observer/Detected by observer 2}
  \item{3}{Seen by both observers}
  \item{4}{Seen by either observer}
  \item{5}{Detected by observer 2/Detected by observer 1 | 2}
  \item{6}{Detected by observer 1/Detected by observer 2 | 1}
}
}
\examples{
\donttest{
data(book.tee.data)
region <- book.tee.data$book.tee.region
egdata <- book.tee.data$book.tee.dataframe
samples <- book.tee.data$book.tee.samples
obs <- book.tee.data$book.tee.obs
xx <- ddf(mrmodel=~glm(formula=~distance*observer),
          dsmodel = ~mcds(key = "hn", formula = ~sex),
          data = egdata, method = "io", meta.data = list(width = 4))
tabs <- det.tables(xx,breaks=c(0,.5,1,2,3,4))
par(mfrow=c(2,3))
plot(tabs,which=1:6,new=FALSE)
}
}
\author{
Jeff Laake, David L Miller
}
