% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dht.se.R
\name{dht.se}
\alias{dht.se}
\title{Variance and confidence intervals for density and abundance estimates}
\usage{
dht.se(model, region.table, samples, obs, options, numRegions, estimate.table,
  Nhat.by.sample)
}
\arguments{
\item{model}{ddf model object}

\item{region.table}{table of region values}

\item{samples}{table of samples(replicates)}

\item{obs}{table of observations}

\item{options}{list of options that can be set (see \code{\link{dht}})}

\item{numRegions}{number of regions}

\item{estimate.table}{table of estimate values}

\item{Nhat.by.sample}{estimated abundances by sample}
}
\value{
List with 2 elements: \item{estimate.table}{completed table with se, cv and confidence limits} \item{vc }{correlation matrix of estimates}
}
\description{
Computes standard error, cv, and log-normal confidence intervals for abundance and density within each region (if any) and for the total of all the regions. It also produces the correlation matrix for regional and total estimates.
}
\details{
The variance has two components:
\itemize{
  \item variation due to uncertainty from estimation of the detection function parameters;
  \item variation in abundance due to random sample selection;
}
The first component (model parameter uncertainty) is computed using a delta method estimate of variance (Huggins 1989, 1991, Borchers et al. 1998) in which the first derivatives of the abundance estimator with respect to the parameters in the detection function are computed numerically (see \code{\link{DeltaMethod}}).

The second component (encounter rate variance) can be computed in one of several ways depending on the form taken for the encounter rate and the estimator used. To begin with there three possible values for \code{varflag} to calculate encounter rate:
\itemize{
 \item \code{0} uses a binomial variance for the number of observations (equation 13 of Borchers et al. 1998). This estimator is only useful if the sampled region is the survey region and the objects are not clustered; this situation will not occur very often;
 \item \code{1} uses the encounter rate \eqn{n/L} (objects observed per unit transect) from Buckland et al. (2001) pg 78-79 (equation 3.78) for line transects (see also Fewster et al, 2009 estimator R2). This variance estimator is not appropriate if \code{size} or a derivative of \code{size} is used in the detection function;
 \item \code{2} is the default and uses the encounter rate estimator \eqn{\hat{N}/L} (estimated abundance per unit transect) suggested by Innes et al (2002) and Marques & Buckland (2004).
}

In general if any covariates are used in the models, the default \code{varflag=2} is preferable as the estimated abundance will take into account variability due to covariate effects. If the population is clustered the mean group size and standard error is also reported.

For options \code{1} and \code{2}, it is then possible to choose one of the estimator forms given in Fewster et al (2009). For line transects: \code{"R2"}, \code{"R3"}, \code{"R4"}, \code{"S1"}, \code{"S2"}, \code{"O1"}, \code{"O2"} or \code{"O3"} can be used by specifying the \code{ervar=} option (default \code{"R2"}). For point transects only the \code{"P3"} estimator may be used. See \code{\link{varn}} and Fewster et al (2009) for further details on these estimators.

Exceptions to the above occur if there is only one sample in a stratum. In that case it uses Poisson assumption (\eqn{Var(x)=x}) and it assumes a known variance so \eqn{z=1.96} is used for critical value. In all other cases the degrees of freedom for the \eqn{t}-distribution assumed for the log(abundance) or log(density) is based on the Satterthwaite approximation (Buckland et al. 2001 pg 90) for the degrees of freedom (df). The df are weighted by the squared cv in combining the two sources of variation because of the assumed log-normal distribution because the components are multiplicative. For combining df for the sampling variance across regions they are weighted by the variance because it is a sum across regions.

A non-zero correlation between regional estimates can occur from using a common detection function across regions. This is reflected in the correlation matrix of the regional and total estimates which is given in the value list. It is only needed if subtotals of regional estimates are needed.
}
\note{
This function is called by \code{dht} and it is not expected that the user will call this function directly but it is documented here for completeness and for anyone expanding the code or using this function in their own code.
}
\references{
see \code{\link{dht}}
}
\seealso{
\code{\link{dht}}, \code{\link{print.dht}}
}
\author{
Jeff Laake
}
\keyword{utility}
