% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{editmetabolitesmrbin}
\alias{editmetabolitesmrbin}
\title{A function for editing metabolite identities.}
\usage{
editmetabolitesmrbin(mrbinObject, borders, metabolitenames, add = TRUE)
}
\arguments{
\item{mrbinObject}{An mrbin object}

\item{borders}{A matrix of signal borders. 1D: two columns: left, right 2D: four columns: left, right, top, bottom}

\item{metabolitenames}{A character vector of metabolite identities}

\item{add}{Should the new metabolite list be added to an existing list, or replace the current list?}
}
\value{
An (invisible) mrbin object
}
\description{
This function edits the metabolite list within an mrbin object and returns it
}
\examples{
 mrbinObject<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,tryParallel=FALSE,
                   NMRfolders=c(system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/3/10/pdata/10",package="mrbin"))
                   ))
 mrbinObject<-editmetabolitesmrbin(mrbinObject,borders=matrix(c(
     1.346,1.324,
     3.052,3.043,
     4.066,4.059
   ),ncol=2,byrow=TRUE),metabolitenames=c(
   "Lactate",
   "Creatinine",
   "Creatinine"
   ))
mrbinObject$parameters$metaboliteIdentities
}
