% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_radarchart.R
\name{plot_radarchart}
\alias{plot_radarchart}
\title{Radar chart}
\usage{
plot_radarchart(input_df)
}
\arguments{
\item{input_df}{Data frame with summary information. Analysis column and at least one category column is required.}
}
\value{
This function returns a radar chart as htmlwidget.
}
\description{
Plot radar chart of summary statistics.
}
\details{
Summary results are displayed via radar chart. Each analysis has its own trace.
}
\examples{
# Load libraries
library(plotly)
library(tibble)

# Example data
data <- tibble::tibble(
 Analysis = c("A", "B"),
 "Median ProteinGroup.IDs [abs.]" = c(5, 10),
 "Median Protein.IDs [abs.]" = c(5, 10),
 "Median Peptide.IDs [abs.]" = c(5, 10),
 "Median Precursor.IDs [abs.]" = c(5, 10),
 "Full profile - Precursor.IDs [abs.]" = c(5, 10),
 "Full profile - Peptide.IDs [abs.]" = c(5, 10),
 "Full profile - Protein.IDs [abs.]" = c(5, 10),
 "Full profile - ProteinGroup.IDs [abs.]" = c(5, 10),
 "Full profile - Precursor.IDs [\%]" = c(5, 10),
 "Full profile - Peptide.IDs [\%]" = c(5, 10),
 "Full profile - Protein.IDs [\%]" = c(5, 10),
 "Full profile - ProteinGroup.IDs [\%]" = c(5, 10),
 "Precursor.IDs [abs.] with a CV Retention time < 5 [\%]" = c(5, 10),
 "Proteingroup.IDs [abs.] with a CV LFQ < 20 [\%]" = c(NA, 10),
 "Peptide.IDs [abs.] with a CV LFQ < 20 [\%]" = c(NA, 10),
 "Peptide IDs with zero missed cleavages [abs.]" = c(5, 10),
 "Peptide IDs with zero missed cleavages [\%]" = c(5, 10)
)

# Plot
plot_radarchart(
  input_df = data
)
}
\author{
Oliver Kardell
}
