% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mppGE_proc.R
\name{mppGE_proc}
\alias{mppGE_proc}
\title{MPP GxE QTL analysis}
\usage{
mppGE_proc(
  pop.name = "MPP",
  trait.name = "trait1",
  mppData,
  trait,
  EnvNames = NULL,
  VCOV = "UN",
  ref_par = NULL,
  VCOV_data = "unique",
  SIM_only = FALSE,
  thre.cof = 4,
  win.cof = 50,
  cof_red = FALSE,
  cof_pval_sign = 0.1,
  window = 20,
  thre.QTL = 4,
  win.QTL = 20,
  text.size = 18,
  n.cores = 1,
  maxIter = 100,
  msMaxIter = 100,
  verbose = TRUE,
  output.loc = NULL
)
}
\arguments{
\item{pop.name}{\code{Character} name of the studied population.
Default = "MPP".}

\item{trait.name}{\code{Character} name of the studied trait.
Default = "trait1".}

\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{EnvNames}{\code{character} expression indicating the environment or trait
labels. By default: Env_1, 2, 3, etc.}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. Default = NULL}

\item{VCOV_data}{\code{Character} specifying if the reference VCOV of the
CIM profile computation should be formed  taking all cofactors into
consideration ("unique") or if different VCOVs should be formed by removing
the cofactor information that is too close of a tested cofactor position
("minus_cof"). Default = "unique"}

\item{SIM_only}{\code{Logical} value specifying if the procedure should
only calculate a SIM profile (no CIM). This option can be used with
large dataset to save time. Default = FALSE}

\item{thre.cof}{\code{Numeric} value representing the -log10(p-value)
threshold above which a position can be selected as cofactor. Default = 4.}

\item{win.cof}{\code{Numeric} value in centi-Morgan representing the minimum
distance between two selected cofactors. Default = 50.}

\item{cof_red}{\code{Logical} value specifying if the cofactor matrix should
be reduced by only keeping the significant allele by environment interaction.
Default = FALSE}

\item{cof_pval_sign}{\code{Numeric} value specifying the p-value significance
of an allele by environment term to be kept in the model. Default = 0.1}

\item{window}{\code{Numeric} distance (cM) on the left and the right of a
cofactor position where it is not included in the model. Default = 20.}

\item{thre.QTL}{\code{Numeric} value representing the -log10(p-value)
threshold above which a position can be selected as QTL. Default = 4.}

\item{win.QTL}{\code{Numeric} value in centi-Morgan representing the minimum
distance between two selected QTLs. Default = 20.}

\item{text.size}{\code{Numeric} value specifying the size of graph axis text
elements. Default = 18.}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}

\item{verbose}{\code{Logical} value indicating if the steps of mpp_proc should
be printed. Default = TRUE.}

\item{output.loc}{Path where a folder will be created to save the results.
Default = NULL.}
}
\value{
Return:

List containing the following items:

\item{n.QTL}{Number of detected QTLs.}

\item{cofactors}{\code{Data.frame} with cofactors positions.}

\item{QTL}{\code{Data.frame} with QTL positions.}

\item{Q_eff}{\code{list} containing the estimated QTL allelic effects.}

\item{R2}{\code{List} containing R squared statistics of the QTL effects}

Some output files are also saved at the specified location
(\code{output.loc}):

\enumerate{

\item{The SIM and CIM results in a RData file (SIM.RData, CIM.RData).}

\item{The list of cofactors (cofactors.RData).}

\item{The list of QTL (QTLs.RData).}

\item{The list of QTL allelic effects (QTL_effects.RData).}

\item{The QTL R squared statistics (QTL_R2.RData)}

\item{The number of detected QTLs and adjusted R2 (Glb_res.RData)}

\item{The plot of the CIM profile (QTL_profile.pdf) with dotted vertical
lines representing the cofactors positions and the
plot of the genetic effects per cross or parents obtained with
\code{\link{plot_allele_eff_GE}} (gen_eff.pdf) with dashed
lines representing the QTL positions.}

}
}
\description{
QTL detection in MPP characterized in multiple environments.
}
\details{
The procedure is the following:

\enumerate{

\item{Simple interval mapping (SIM) to select cofactors
(\code{\link{mppGE_SIM}}).}

\item{Composite interval mapping (CIM) with selected cofactors
(\code{\link{mppGE_CIM}}).}

\item{Estimation of QTLs additive allelic effect
(\code{\link{QTL_effect_GE}}).}

\item{Estimation of the global QTLs effect R squared and individual QTL effect
R squared (\code{\link{QTL_R2_GE}}).}

}
}
\examples{

\dontrun{

data(mppData_GE)

MPP_GE_QTL <- mppGE_proc(pop.name = 'EUNAM', trait.name = 'DMY',
mppData = mppData_GE, trait = c('DMY_CIAM', 'DMY_TUM'),
n.cores = 1, output.loc = tempdir())

}

}
\seealso{
\code{\link{mppGE_CIM}},
\code{\link{mppGE_SIM}},
\code{\link{QTL_effect_GE}},
\code{\link{QTL_R2_GE}}
}
\author{
Vincent Garin
}
