% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.mpitb.R
\name{coef.cotframe}
\alias{coef.cotframe}
\title{Extract the coefficients from the estimated changes over time measures}
\usage{
\method{coef}{cotframe}(object, ...)
}
\arguments{
\item{object}{a "cotframe"-class object}

\item{...}{other arguments.}
}
\value{
Coefficients extracted from the model \code{cotframe} object.
}
\description{
Extract the coefficients from the estimated changes over time measures
}
\details{
The \code{coef} method for "cotframe"-class objects find the point estimates
from the changes over time data frame. This method work for
only one measure \code{c("M0","H","A","hd","hdk")}. Then, user should subset the
data frame with the estimates by the chosen measure (including other preferred categories, i.e.,
poverty cut-off, subgroup, etc.)
}
\examples{
library(mpitbR)

data <- subset(syn_cdta)
data <- na.omit(data)

svydata <- survey::svydesign(id=~psu, weights = ~weight, strata = ~stratum, data = data)

indicators <- list(d1 = c("d_nutr","d_cm"),
                   d2 = c("d_satt","d_educ"),
                   d3 = c("d_elct","d_sani","d_wtr","d_hsg","d_ckfl","d_asst"))

# Specify mpitb project
set <- mpitb.set(svydata, indicators = indicators, name = "myname", desc = "pref. desc")

# Estimate the cross-sectional MPI and compare non-annualized changes over time
est <- mpitb.est(set, klist = c(33), measures = "M0", indmeasures = NULL,
                 tvar = "t", cotmeasures = "M0",
                 weights = "equal", over = c("area"))

coef(subset(est$lframe, measure == "M0" & t == 1))
confint(subset(est$lframe, measure == "M0" & t == 1))
summary(subset(est$lframe, measure == "M0" & t == 1))

coef(subset(est$cotframe, measure == "M0"))
confint(subset(est$cotframe, measure == "M0"))
summary(subset(est$cotframe, measure == "M0" & ctype == "abs" & ann == 0 & k == 33))
}
\seealso{
\code{confint}, and \code{summary} methods, and \code{mpitb.est} function.
}
\author{
Ignacio Girela
}
