% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nLines.R
\name{nLines}
\alias{nLines}
\alias{nLines,mpcross-method}
\alias{nLines,geneticData-method}
\title{Number of genotyped lines

Return the number of genotyped lines in an object.

This includes only the number of final lines genotyped in the population, and does not include the founding lines. If an \code{mpcross} object contains multiple experiments, one number is returned per experiment.}
\usage{
nLines(object)

\S4method{nLines}{mpcross}(object)

\S4method{nLines}{geneticData}(object)
}
\arguments{
\item{object}{The \code{mpcross} object from which to extract the number of genotyped lines.}
}
\value{
The number of genetic lines in the population, or a list of numbers in the case of multiple experiments contained in a single object.
}
\description{
Number of genotyped lines

Return the number of genotyped lines in an object.

This includes only the number of final lines genotyped in the population, and does not include the founding lines. If an \code{mpcross} object contains multiple experiments, one number is returned per experiment.
}
