% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founders.R
\name{founders}
\alias{founders}
\alias{founders,mpcross-method}
\alias{founders,geneticData-method}
\title{Genetic data for founding lines

Return the genetic data matrix for the founding lines

If the \code{mpcross} object contains a single experiment a matrix is returned, with rows corresponding to founding lines and columns corresponding to markers. If an \code{mpcross} object contains multiple experiments a list of such matrices is returned, one for each experiment.}
\usage{
founders(object)

\S4method{founders}{mpcross}(object)

\S4method{founders}{geneticData}(object)
}
\arguments{
\item{object}{The \code{mpcross} object from which to extract the genetic data matrix of the founding lines}
}
\value{
An integer matrix, with rows corresponding to founding lines and columns corresponding to markers, or a list of such matrices in the case of multiple experiments.
}
\description{
Genetic data for founding lines

Return the genetic data matrix for the founding lines

If the \code{mpcross} object contains a single experiment a matrix is returned, with rows corresponding to founding lines and columns corresponding to markers. If an \code{mpcross} object contains multiple experiments a list of such matrices is returned, one for each experiment.
}
