% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateRFSingleDesign.R
\name{estimateRFSingleDesign}
\alias{estimateRFSingleDesign}
\title{Estimate pairwise recombination fractions}
\usage{
estimateRFSingleDesign(
  object,
  recombValues,
  lineWeights,
  keepLod = FALSE,
  keepLkhd = FALSE,
  verbose = FALSE,
  markerRows = 1:nMarkers(object),
  markerColumns = 1:nMarkers(object)
)
}
\arguments{
\item{object}{An object of class \code{mpcross}.}

\item{recombValues}{a vector of test values to use for the numeric maximum likelihood step. Must contain 0 and 0.5, and must have less than 255 values in total. The default value is \code{c(0:20/200, 11:50/100)}.}

\item{lineWeights}{Values to use to correct for segregation distortion. This parameter should in general be left unspecified.}

\item{keepLod}{Set to \code{TRUE} to compute the likelihood ratio score statistics for testing whether the estimate is different from 0.5. Due to memory constraints this should generally be left as \code{FALSE}.}

\item{keepLkhd}{Set to \code{TRUE} to compute the maximum value of the likelihood. Due to memory constraints this should generally be left as \code{FALSE}.}

\item{verbose}{Output diagnostic information, such as the amount of memory required, and the progress of the computation.}

\item{markerRows}{Used to estimate only a subset of the full matrix of pairwise recombination fractions.}

\item{markerColumns}{Used to estimate only a subset of the full matrix of pairwise recombination fractions.}
}
\value{
An object of class \code{mpcrossRF}, which contains the original genetic data, and also estimated recombination fraction data.
}
\description{
Estimate pairwise recombination fractions, similar to \code{\link{estimateRF}}, but with different performance requirements in terms of compute time and storage.
}
\details{
Estimate pairwise recombination fractions, similar to \code{\link{estimateRF}}, but with different performance requirements in terms of compute time and storage. Specifically, this version is expected to perform better when there is only a single population.
}
